/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.eureka;

import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.eureka.EurekaUpdatingListener;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.server.internal.eureka.ZipkinEurekaDiscoveryProperties;

@ConditionalOnClass(value={EurekaUpdatingListener.class})
@Conditional(value={EurekaServiceUrlSet.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinEurekaDiscoveryProperties.class})
public class ZipkinEurekaDiscoveryConfiguration {
    @Bean
    EurekaUpdatingListener eurekaListener(ZipkinEurekaDiscoveryProperties eureka) {
        return eureka.toBuilder().build();
    }

    @Bean
    ArmeriaServerConfigurator eurekaListenerConfigurator(EurekaUpdatingListener listener) {
        return sb -> sb.serverListener((ServerListener)listener);
    }

    static final class EurekaServiceUrlSet
    implements Condition {
        EurekaServiceUrlSet() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata a) {
            return !EurekaServiceUrlSet.isEmpty(context.getEnvironment().getProperty("zipkin.discovery.eureka.service-url")) && EurekaServiceUrlSet.notFalse(context.getEnvironment().getProperty("zipkin.discovery.eureka.enabled"));
        }

        private static boolean isEmpty(String s) {
            return s == null || s.isEmpty();
        }

        private static boolean notFalse(String s) {
            return s == null || !s.equals("false");
        }
    }
}

