/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Conditional(value={ThrottledStorageCondition.class})
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@interface ConditionalOnThrottledStorage {

    public static class ThrottledStorageCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String throttleEnabled = context.getEnvironment().getProperty("zipkin.storage.throttle.enabled");
            if (!Boolean.valueOf(throttleEnabled).booleanValue()) {
                return ConditionOutcome.noMatch((String)"zipkin.storage.throttle.enabled isn't true");
            }
            return ConditionOutcome.match();
        }
    }
}

