/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.brave;

import brave.Tracer;
import brave.Tracing;
import java.io.IOException;
import java.util.List;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.server.internal.brave.TracedCall;
import zipkin2.storage.AutocompleteTags;
import zipkin2.storage.ForwardingStorageComponent;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.Traces;

public final class TracingStorageComponent
extends ForwardingStorageComponent {
    final Tracing tracing;
    final StorageComponent delegate;

    public TracingStorageComponent(Tracing tracing, StorageComponent delegate) {
        this.tracing = tracing;
        this.delegate = delegate;
    }

    protected StorageComponent delegate() {
        return this.delegate;
    }

    public ServiceAndSpanNames serviceAndSpanNames() {
        return new TracingServiceAndSpanNames(this.tracing, this.delegate.serviceAndSpanNames());
    }

    public Traces traces() {
        return new TracingTraces(this.tracing, this.delegate.traces());
    }

    public SpanStore spanStore() {
        return new TracingSpanStore(this.tracing, this.delegate.spanStore());
    }

    public AutocompleteTags autocompleteTags() {
        return new TracingAutocompleteTags(this.tracing, this.delegate.autocompleteTags());
    }

    public SpanConsumer spanConsumer() {
        return new TracingSpanConsumer(this.tracing, this.delegate.spanConsumer());
    }

    public CheckResult check() {
        return this.delegate.check();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return "Traced{" + this.delegate + "}";
    }

    static final class TracingSpanConsumer
    implements SpanConsumer {
        final Tracer tracer;
        final SpanConsumer delegate;

        TracingSpanConsumer(Tracing tracing, SpanConsumer delegate) {
            this.tracer = tracing.tracer();
            this.delegate = delegate;
        }

        public Call<Void> accept(List<Span> spans) {
            return new TracedCall<Void>(this.tracer, this.delegate.accept(spans), "accept-spans");
        }

        public String toString() {
            return "Traced{" + this.delegate + "}";
        }
    }

    static final class TracingServiceAndSpanNames
    implements ServiceAndSpanNames {
        final Tracer tracer;
        final ServiceAndSpanNames delegate;

        TracingServiceAndSpanNames(Tracing tracing, ServiceAndSpanNames delegate) {
            this.tracer = tracing.tracer();
            this.delegate = delegate;
        }

        public Call<List<String>> getServiceNames() {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getServiceNames(), "get-service-names");
        }

        public Call<List<String>> getRemoteServiceNames(String serviceName) {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getRemoteServiceNames(serviceName), "get-remote-service-names");
        }

        public Call<List<String>> getSpanNames(String serviceName) {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getSpanNames(serviceName), "get-span-names");
        }

        public String toString() {
            return "Traced{" + this.delegate + "}";
        }
    }

    static final class TracingAutocompleteTags
    implements AutocompleteTags {
        final Tracer tracer;
        final AutocompleteTags delegate;

        TracingAutocompleteTags(Tracing tracing, AutocompleteTags delegate) {
            this.tracer = tracing.tracer();
            this.delegate = delegate;
        }

        public Call<List<String>> getKeys() {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getKeys(), "get-keys");
        }

        public Call<List<String>> getValues(String key) {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getValues(key), "get-values");
        }

        public String toString() {
            return "Traced{" + this.delegate + "}";
        }
    }

    static final class TracingSpanStore
    implements SpanStore {
        final Tracer tracer;
        final SpanStore delegate;

        TracingSpanStore(Tracing tracing, SpanStore delegate) {
            this.tracer = tracing.tracer();
            this.delegate = delegate;
        }

        public Call<List<List<Span>>> getTraces(QueryRequest request) {
            return new TracedCall<List<List<Span>>>(this.tracer, this.delegate.getTraces(request), "get-traces");
        }

        @Deprecated
        public Call<List<Span>> getTrace(String traceId) {
            return new TracedCall<List<Span>>(this.tracer, this.delegate.getTrace(traceId), "get-trace");
        }

        @Deprecated
        public Call<List<String>> getServiceNames() {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getServiceNames(), "get-service-names");
        }

        @Deprecated
        public Call<List<String>> getSpanNames(String serviceName) {
            return new TracedCall<List<String>>(this.tracer, this.delegate.getSpanNames(serviceName), "get-span-names");
        }

        public Call<List<DependencyLink>> getDependencies(long endTs, long lookback) {
            return new TracedCall<List<DependencyLink>>(this.tracer, this.delegate.getDependencies(endTs, lookback), "get-dependencies");
        }

        public String toString() {
            return "Traced{" + this.delegate + "}";
        }
    }

    static final class TracingTraces
    implements Traces {
        final Tracer tracer;
        final Traces delegate;

        TracingTraces(Tracing tracing, Traces delegate) {
            this.tracer = tracing.tracer();
            this.delegate = delegate;
        }

        public Call<List<Span>> getTrace(String traceId) {
            return new TracedCall<List<Span>>(this.tracer, this.delegate.getTrace(traceId), "get-trace");
        }

        public Call<List<List<Span>>> getTraces(Iterable<String> traceIds) {
            return new TracedCall<List<List<Span>>>(this.tracer, this.delegate.getTraces(traceIds), "get-traces");
        }

        public String toString() {
            return "Traced{" + this.delegate + "}";
        }
    }
}

