/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.cassandra;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.cassandra.ZipkinCassandraStorageProperties;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.cassandra.v1.CassandraStorage;
import zipkin2.storage.cassandra.v1.SessionFactory;

@ConditionalOnClass(value={CassandraStorage.class})
@EnableConfigurationProperties(value={ZipkinCassandraStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra")
@ConditionalOnMissingBean(value={StorageComponent.class})
@Import(value={TracingSessionFactoryEnhancer.class})
public class ZipkinCassandraStorageConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(ZipkinCassandraStorageConfiguration.class);

    @Bean
    SessionFactory sessionFactory() {
        return new SessionFactory.Default();
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinCassandraStorageProperties properties, SessionFactory sessionFactory, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        LOG.warn("\"STORAGE_TYPE=cassandra\" is deprecated and will be removed in Zipkin v2.23.\nPlease change to \"STORAGE_TYPE=cassandra3\", noting this requires Cassandra v3.11.3+ with SASI enabled.\nContact https://gitter.im/openzipkin/zipkin for more information.");
        return ((CassandraStorage.Builder)((CassandraStorage.Builder)((CassandraStorage.Builder)((CassandraStorage.Builder)((CassandraStorage.Builder)properties.toBuilder().strictTraceId(strictTraceId)).searchEnabled(searchEnabled)).autocompleteKeys(autocompleteKeys)).autocompleteTtl(autocompleteTtl)).autocompleteCardinality(autocompleteCardinality)).sessionFactory(sessionFactory).build();
    }

    @ConditionalOnSelfTracing
    static class TracingSessionFactoryEnhancer
    implements BeanPostProcessor,
    BeanFactoryAware {
        BeanFactory beanFactory;

        TracingSessionFactoryEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            return bean;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

