/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.kafka;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.kafka.KafkaCollector;
import zipkin2.server.internal.kafka.ZipkinKafkaCollectorProperties;
import zipkin2.storage.StorageComponent;

@ConditionalOnClass(value={KafkaCollector.class})
@Conditional(value={KafkaBootstrapServersSet.class})
@EnableConfigurationProperties(value={ZipkinKafkaCollectorProperties.class})
public class ZipkinKafkaCollectorConfiguration {
    @Bean(initMethod="start")
    KafkaCollector kafka(ZipkinKafkaCollectorProperties properties, CollectorSampler sampler, CollectorMetrics metrics, StorageComponent storage) {
        return properties.toBuilder().sampler(sampler).metrics(metrics).storage(storage).build();
    }

    static final class KafkaBootstrapServersSet
    implements Condition {
        KafkaBootstrapServersSet() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata a) {
            return !KafkaBootstrapServersSet.isEmpty(context.getEnvironment().getProperty("zipkin.collector.kafka.bootstrap-servers")) && KafkaBootstrapServersSet.notFalse(context.getEnvironment().getProperty("zipkin.collector.kafka.enabled"));
        }

        private static boolean isEmpty(String s) {
            return s == null || s.isEmpty();
        }

        private static boolean notFalse(String s) {
            return s == null || !s.equals("false");
        }
    }
}

