/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.StaticEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.AbstractListenable;
import com.linecorp.armeria.common.util.Exceptions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import zipkin2.Endpoint;
import zipkin2.server.internal.elasticsearch.HostsConverter;

final class InitialEndpointSupplier
implements Supplier<EndpointGroup> {
    final String hosts;
    final SessionProtocol sessionProtocol;

    InitialEndpointSupplier(SessionProtocol sessionProtocol, String hosts) {
        this.hosts = hosts == null || hosts.isEmpty() ? "localhost:9200" : hosts;
        this.sessionProtocol = sessionProtocol;
    }

    @Override
    public EndpointGroup get() {
        List<URI> initialURLs = HostsConverter.convert(this.hosts);
        if (initialURLs.size() == 1) {
            URI url = initialURLs.get(0);
            String host = url.getHost();
            int port = this.getPort(url);
            if (InitialEndpointSupplier.isIpAddress(host) || host.equals("localhost")) {
                return new StaticEndpointGroup(new com.linecorp.armeria.client.Endpoint[]{com.linecorp.armeria.client.Endpoint.of((String)host, (int)port)});
            }
            return this.resolveDnsAddresses(host, port);
        }
        ArrayList<EndpointGroup> endpointGroups = new ArrayList<EndpointGroup>();
        ArrayList<com.linecorp.armeria.client.Endpoint> staticEndpoints = new ArrayList<com.linecorp.armeria.client.Endpoint>();
        for (URI url : initialURLs) {
            com.linecorp.armeria.client.Endpoint endpoint = com.linecorp.armeria.client.Endpoint.parse((String)url.getAuthority());
            if (InitialEndpointSupplier.isIpAddress(url.getHost())) {
                staticEndpoints.add(endpoint);
                continue;
            }
            endpointGroups.add((EndpointGroup)this.resolveDnsAddresses(url.getHost(), this.getPort(url)));
        }
        if (!staticEndpoints.isEmpty()) {
            endpointGroups.add((EndpointGroup)new StaticEndpointGroup(staticEndpoints));
        }
        return endpointGroups.size() == 1 ? (EndpointGroup)endpointGroups.get(0) : new CompositeEndpointGroup(endpointGroups);
    }

    DnsAddressEndpointGroup resolveDnsAddresses(String host, int port) {
        DnsAddressEndpointGroup result = new DnsAddressEndpointGroupBuilder(host).port(port).build();
        try {
            result.awaitInitialEndpoints(1L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    int getPort(URI url) {
        int port = url.getPort();
        if (port == -1) {
            port = this.sessionProtocol.defaultPort();
        }
        return port;
    }

    static boolean isIpAddress(String address) {
        return Endpoint.newBuilder().parseIp(address);
    }

    public String toString() {
        return this.hosts;
    }

    static class CompositeEndpointGroup
    extends AbstractListenable<List<com.linecorp.armeria.client.Endpoint>>
    implements EndpointGroup {
        static final AtomicIntegerFieldUpdater<CompositeEndpointGroup> dirtyUpdater = AtomicIntegerFieldUpdater.newUpdater(CompositeEndpointGroup.class, "dirty");
        final List<EndpointGroup> endpointGroups;
        final CompletableFuture<List<com.linecorp.armeria.client.Endpoint>> initialEndpointsFuture;
        volatile List<com.linecorp.armeria.client.Endpoint> merged = Collections.emptyList();
        volatile int dirty;

        CompositeEndpointGroup(List<EndpointGroup> endpointGroups) {
            this.endpointGroups = endpointGroups;
            for (EndpointGroup group : endpointGroups) {
                group.addListener(unused -> this.notifyListeners(this.endpoints()));
            }
            this.initialEndpointsFuture = CompletableFuture.anyOf((CompletableFuture[])endpointGroups.stream().map(EndpointGroup::initialEndpointsFuture).toArray(CompletableFuture[]::new)).thenApply(unused -> this.endpoints());
        }

        public List<com.linecorp.armeria.client.Endpoint> endpoints() {
            if (this.dirty == 0) {
                return this.merged;
            }
            if (!dirtyUpdater.compareAndSet(this, 1, 0)) {
                return this.merged;
            }
            ArrayList newEndpoints = new ArrayList();
            for (EndpointGroup endpointGroup : this.endpointGroups) {
                newEndpoints.addAll(endpointGroup.endpoints());
            }
            this.merged = Collections.unmodifiableList(newEndpoints);
            return this.merged;
        }

        public CompletableFuture<List<com.linecorp.armeria.client.Endpoint>> initialEndpointsFuture() {
            return this.initialEndpointsFuture;
        }

        public void close() {
            Throwable t = null;
            for (EndpointGroup endpointGroup : this.endpointGroups) {
                try {
                    endpointGroup.close();
                }
                catch (Throwable thrown) {
                    if (t != null) continue;
                    t = thrown;
                }
            }
            if (t != null) {
                Exceptions.throwUnsafely(t);
            }
        }
    }
}

