/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.cassandra3;

import brave.Tracing;
import brave.cassandra.driver.TracingSession;
import com.datastax.driver.core.Session;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.cassandra3.ZipkinCassandra3StorageProperties;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.cassandra.CassandraStorage;

@Configuration
@EnableConfigurationProperties(value={ZipkinCassandra3StorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra3")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinCassandra3StorageConfiguration {
    @Bean
    CassandraStorage.SessionFactory sessionFactory() {
        return CassandraStorage.SessionFactory.DEFAULT;
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinCassandra3StorageProperties properties, CassandraStorage.SessionFactory sessionFactory, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        return properties.toBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).autocompleteTtl(autocompleteTtl).autocompleteCardinality(autocompleteCardinality).sessionFactory(sessionFactory).build();
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class TracingSessionFactoryEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Tracing tracing;

        TracingSessionFactoryEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (this.tracing == null) {
                return bean;
            }
            if (bean instanceof CassandraStorage.SessionFactory) {
                CassandraStorage.SessionFactory delegate = (CassandraStorage.SessionFactory)bean;
                return storage -> TracingSession.create((Tracing)this.tracing, (Session)delegate.create(storage));
            }
            return bean;
        }
    }
}

