/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.brave;

import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.brave.MutableSpanBenchmarks;
import zipkin2.reporter.brave.ZipkinSpanHandler;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
public class ZipkinSpanHandlerBenchmarks {
    final SpanHandler handler = ZipkinSpanHandler.newBuilder((Reporter)Reporter.NOOP).alwaysReportSpans(true).build();
    final TraceContext context = TraceContext.newBuilder().traceId(1L).spanId(2L).sampled(true).build();
    final MutableSpan serverSpan = MutableSpanBenchmarks.newServerSpan();
    final MutableSpan bigClientSpan = MutableSpanBenchmarks.newBigClientSpan();

    @Benchmark
    public boolean handleServerSpan() {
        return this.handler.end(this.context, this.serverSpan, SpanHandler.Cause.FINISHED);
    }

    @Benchmark
    public boolean handleBigClientSpan() {
        return this.handler.end(this.context, this.bigClientSpan, SpanHandler.Cause.FINISHED);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().addProfiler("gc").include(".*" + ZipkinSpanHandlerBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

