/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import java.io.IOException;
import org.junit.AssumptionViolatedException;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.CheckResult;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SenderBenchmarks;
import zipkin2.reporter.amqp.RabbitMQSender;

public class RabbitMQSenderBenchmarks
extends SenderBenchmarks {
    private Channel channel;

    @Override
    protected Sender createSender() throws Exception {
        RabbitMQSender result = RabbitMQSender.newBuilder().queue("zipkin-jmh").addresses("localhost:5672").build();
        CheckResult check = result.check();
        if (!check.ok()) {
            throw new AssumptionViolatedException(check.error().getMessage(), check.error());
        }
        this.channel = result.localChannel();
        this.channel.queueDelete(result.queue);
        this.channel.queueDeclare(result.queue, false, true, true, null);
        Thread.sleep(500L);
        new Thread(() -> {
            try {
                this.channel.basicConsume(result.queue, true, (Consumer)new DefaultConsumer(this.channel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        return result;
    }

    @Override
    protected void afterSenderClose() {
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + RabbitMQSenderBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

