/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.util.List;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;

final class NoopSender
extends Sender {
    final Encoding encoding;
    final BytesMessageEncoder messageEncoder;
    volatile boolean closeCalled;

    NoopSender(Encoding encoding) {
        this.encoding = encoding;
        this.messageEncoder = BytesMessageEncoder.forEncoding((Encoding)encoding);
    }

    public int messageMaxBytes() {
        return Integer.MAX_VALUE;
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding().listSizeInBytes(encodedSizeInBytes);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        this.messageEncoder.encode(encodedSpans);
        return Call.create(null);
    }

    public CheckResult check() {
        return CheckResult.OK;
    }

    public void close() {
        this.closeCalled = true;
    }

    public String toString() {
        return "NoopSender";
    }
}

