/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import com.github.charithe.kafka.EphemeralKafkaBroker;
import com.github.charithe.kafka.KafkaJunitRule;
import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SenderBenchmarks;
import zipkin2.reporter.kafka.KafkaSender;

public class KafkaSenderBenchmarks
extends SenderBenchmarks {
    EphemeralKafkaBroker broker = EphemeralKafkaBroker.create();
    KafkaJunitRule kafka;
    KafkaConsumer<byte[], byte[]> consumer;

    @Override
    protected Sender createSender() throws Exception {
        this.broker.start();
        this.kafka = new KafkaJunitRule(this.broker).waitForStartup();
        this.consumer = this.kafka.helper().createByteConsumer();
        this.consumer.subscribe(Collections.singletonList("zipkin"));
        new Thread(() -> {
            block0: while (true) {
                Iterator messages = this.consumer.poll(1000L).iterator();
                while (true) {
                    if (!messages.hasNext()) continue block0;
                    messages.next();
                }
                break;
            }
        }).start();
        return KafkaSender.create((String)((String)this.broker.getBrokerList().get()));
    }

    @Override
    protected void afterSenderClose() throws Exception {
        this.broker.stop();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + KafkaSenderBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

