/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.reporter.ByteBoundedQueue;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Group)
public class ByteBoundedQueueBenchmarks {
    static final byte ONE = 1;
    private static ThreadLocal<Object> marker = new ThreadLocal();
    ByteBoundedQueue<Byte> q;

    @Setup
    public void setup() {
        this.q = new ByteBoundedQueue(10000, 10000);
    }

    @Benchmark
    @Group(value="no_contention")
    @GroupThreads(value=1)
    public void no_contention_offer(OfferCounters counters) {
        if (this.q.offer((Object)1, 1)) {
            ++counters.offersMade;
        } else {
            ++counters.offersFailed;
        }
    }

    @Benchmark
    @Group(value="no_contention")
    @GroupThreads(value=1)
    public void no_contention_drain(DrainCounters counters, ConsumerMarker cm) {
        this.q.drainTo((s, b) -> {
            ++counters.drained;
            return true;
        }, 1000L);
    }

    @Benchmark
    @Group(value="mild_contention")
    @GroupThreads(value=2)
    public void mild_contention_offer(OfferCounters counters) {
        if (this.q.offer((Object)1, 1)) {
            ++counters.offersMade;
        } else {
            ++counters.offersFailed;
        }
    }

    @Benchmark
    @Group(value="mild_contention")
    @GroupThreads(value=1)
    public void mild_contention_drain(DrainCounters counters, ConsumerMarker cm) {
        this.q.drainTo((s, b) -> {
            ++counters.drained;
            return true;
        }, 1000L);
    }

    @Benchmark
    @Group(value="high_contention")
    @GroupThreads(value=8)
    public void high_contention_offer(OfferCounters counters) {
        if (this.q.offer((Object)1, 1)) {
            ++counters.offersMade;
        } else {
            ++counters.offersFailed;
        }
    }

    @Benchmark
    @Group(value="high_contention")
    @GroupThreads(value=1)
    public void high_contention_drain(DrainCounters counters, ConsumerMarker cm) {
        this.q.drainTo((s, b) -> {
            ++counters.drained;
            return true;
        }, 1000L);
    }

    @TearDown(value=Level.Iteration)
    public void emptyQ() {
        if (marker.get() == null) {
            return;
        }
        this.q.clear();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + ByteBoundedQueueBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class ConsumerMarker {
        public ConsumerMarker() {
            marker.set(this);
        }
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class DrainCounters {
        public int drained;

        @Setup(value=Level.Iteration)
        public void clean() {
            this.drained = 0;
        }
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class OfferCounters {
        public int offersFailed;
        public int offersMade;

        @Setup(value=Level.Iteration)
        public void clean() {
            this.offersMade = 0;
            this.offersFailed = 0;
        }
    }
}

