/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.codec.Encoding;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.NoopSender;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Group)
public class AsyncReporterBenchmarks {
    static final Span clientSpan = TestObjects.CLIENT_SPAN;
    static final InMemoryReporterMetrics metrics = new InMemoryReporterMetrics();
    static final AtomicLong spanBacklog = new AtomicLong();
    @Param
    public Encoding encoding;
    AsyncReporter<Span> reporter;

    @Setup(value=Level.Trial)
    public void setup() {
        this.reporter = AsyncReporter.builder((Sender)new NoopSender(this.encoding)).messageMaxBytes(1000000).metrics((ReporterMetrics)metrics).build();
    }

    @Benchmark
    @Group(value="no_contention")
    @GroupThreads(value=1)
    public void no_contention_report(InMemoryReporterMetricsAsCounters counters) {
        this.reporter.report((Object)clientSpan);
    }

    @Benchmark
    @Group(value="mild_contention")
    @GroupThreads(value=2)
    public void mild_contention_report(InMemoryReporterMetricsAsCounters counters) {
        this.reporter.report((Object)clientSpan);
    }

    @Benchmark
    @Group(value="high_contention")
    @GroupThreads(value=8)
    public void high_contention_report(InMemoryReporterMetricsAsCounters counters) {
        this.reporter.report((Object)clientSpan);
    }

    @TearDown(value=Level.Iteration)
    public void clear() throws IOException {
        spanBacklog.addAndGet(((AsyncReporter.BoundedAsyncReporter)this.reporter).pending.clear());
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class InMemoryReporterMetricsAsCounters {
        public long spans() {
            return metrics.spans();
        }

        public long spansDropped() {
            return metrics.spansDropped();
        }

        public long messages() {
            return metrics.messages();
        }

        public long messagesDropped() {
            return metrics.messagesDropped();
        }

        public long spanBacklog() {
            return spanBacklog.get();
        }

        @Setup(value=Level.Iteration)
        public void clean() {
            metrics.clear();
            spanBacklog.set(0L);
        }
    }
}

