/**
 * Copyright 2015-2017 The OpenZipkin Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file is generated by jOOQ.
*/
package zipkin.storage.mysql.internal.generated;


import javax.annotation.Generated;

import org.jooq.Record;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractKeys;

import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinDependencies;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;


/**
 * A class modelling foreign key relationships between tables of the <code>zipkin</code> 
 * schema
 */
@Generated(
    value = {
        "http://www.jooq.org",
        "jOOQ version:3.9.1"
    },
    comments = "This class is generated by jOOQ"
)
@SuppressWarnings({ "all", "unchecked", "rawtypes" })
public class Keys {

    // -------------------------------------------------------------------------
    // IDENTITY definitions
    // -------------------------------------------------------------------------


    // -------------------------------------------------------------------------
    // UNIQUE and PRIMARY KEY definitions
    // -------------------------------------------------------------------------

    public static final UniqueKey<Record> KEY_ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH = UniqueKeys0.KEY_ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH;
    public static final UniqueKey<Record> KEY_ZIPKIN_DEPENDENCIES_DAY = UniqueKeys0.KEY_ZIPKIN_DEPENDENCIES_DAY;
    public static final UniqueKey<Record> KEY_ZIPKIN_SPANS_TRACE_ID_HIGH = UniqueKeys0.KEY_ZIPKIN_SPANS_TRACE_ID_HIGH;

    // -------------------------------------------------------------------------
    // FOREIGN KEY definitions
    // -------------------------------------------------------------------------


    // -------------------------------------------------------------------------
    // [#1459] distribute members to avoid static initialisers > 64kb
    // -------------------------------------------------------------------------

    private static class UniqueKeys0 extends AbstractKeys {
        public static final UniqueKey<Record> KEY_ZIPKIN_ANNOTATIONS_TRACE_ID_HIGH = createUniqueKey(ZipkinAnnotations.ZIPKIN_ANNOTATIONS, "KEY_zipkin_annotations_trace_id_high", ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP);
        public static final UniqueKey<Record> KEY_ZIPKIN_DEPENDENCIES_DAY = createUniqueKey(ZipkinDependencies.ZIPKIN_DEPENDENCIES, "KEY_zipkin_dependencies_day", ZipkinDependencies.ZIPKIN_DEPENDENCIES.DAY, ZipkinDependencies.ZIPKIN_DEPENDENCIES.PARENT, ZipkinDependencies.ZIPKIN_DEPENDENCIES.CHILD);
        public static final UniqueKey<Record> KEY_ZIPKIN_SPANS_TRACE_ID_HIGH = createUniqueKey(ZipkinSpans.ZIPKIN_SPANS, "KEY_zipkin_spans_trace_id_high", ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, ZipkinSpans.ZIPKIN_SPANS.ID);
    }
}
