/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.ui;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import zipkin.autoconfigure.ui.ZipkinUiProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinUiProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
@RestController
public class ZipkinUiAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-ui/index.html")
    Resource indexHtml;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/zipkin-ui/"}).setCachePeriod(Integer.valueOf((int)TimeUnit.DAYS.toSeconds(365L)));
    }

    @Bean
    @Order(value=-2147483648)
    public CharacterEncodingFilter characterEncodingFilter() {
        CharacterEncodingFilter filter = new CharacterEncodingFilter(){

            protected boolean shouldNotFilter(HttpServletRequest request) {
                return request.getServletPath().endsWith(".png");
            }
        };
        filter.setEncoding("UTF-8");
        filter.setForceEncoding(true);
        return filter;
    }

    @RequestMapping(value={"/config.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<ZipkinUiProperties> serveUiConfig() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.MINUTES))).body((Object)this.ui);
    }

    @RequestMapping(value={"/index.html"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> serveIndex() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).body((Object)this.indexHtml);
    }

    @RequestMapping(value={"/", "/traces/{id}", "/dependency"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints(ModelMap model) {
        return new ModelAndView("forward:/index.html", (Map)model);
    }
}

