/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver;

import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.TraceServiceGrpc;
import com.google.devtools.cloudtrace.v1.Traces;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Empty;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;
import zipkin2.reporter.stackdriver.PatchTracesRequestSizer;
import zipkin2.reporter.stackdriver.TraceCollator;
import zipkin2.reporter.stackdriver.TracesParser;
import zipkin2.reporter.stackdriver.internal.UnaryClientCall;

public final class StackdriverSender
extends Sender {
    final Channel channel;
    final CallOptions callOptions;
    final String projectId;
    final boolean shutdownChannelOnClose;
    final int projectIdFieldSize;
    final ThreadLocal<TraceCollator> traceCollator = new ThreadLocal<TraceCollator>(){

        @Override
        protected TraceCollator initialValue() {
            return new TraceCollator();
        }
    };
    volatile boolean closeCalled;

    public static Builder newBuilder() {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"cloudtrace.googleapis.com").build();
        Builder result = StackdriverSender.newBuilder((Channel)channel);
        result.shutdownChannelOnClose = true;
        return result;
    }

    public static Builder newBuilder(Channel channel) {
        return new Builder(channel);
    }

    StackdriverSender(Builder builder) {
        this.channel = builder.channel;
        this.callOptions = builder.callOptions;
        this.projectId = builder.projectId;
        this.shutdownChannelOnClose = builder.shutdownChannelOnClose;
        this.projectIdFieldSize = 1 + CodedOutputStream.computeStringSizeNoTag((String)this.projectId);
    }

    public Encoding encoding() {
        return Encoding.PROTO3;
    }

    public int messageMaxBytes() {
        return 0x100000;
    }

    public int messageSizeInBytes(List<byte[]> traceIdPrefixedSpans) {
        int length = traceIdPrefixedSpans.size();
        if (length == 0) {
            return 0;
        }
        if (length == 1) {
            return this.messageSizeInBytes(traceIdPrefixedSpans.get(0).length);
        }
        PatchTracesRequestSizer sizer = new PatchTracesRequestSizer(this.projectIdFieldSize);
        this.traceCollator.get().collate(traceIdPrefixedSpans, sizer);
        return sizer.finish();
    }

    public int messageSizeInBytes(int traceIdPrefixedSpanSize) {
        return PatchTracesRequestSizer.size(this.projectIdFieldSize, traceIdPrefixedSpanSize - 32);
    }

    public Call<Void> sendSpans(List<byte[]> traceIdPrefixedSpans) {
        Traces traces;
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        int length = traceIdPrefixedSpans.size();
        if (length == 0) {
            return Call.create(null);
        }
        if (length == 1) {
            traces = TracesParser.parse(this.projectId, traceIdPrefixedSpans.get(0));
        } else {
            TracesParser parser = new TracesParser(this.projectId);
            this.traceCollator.get().collate(traceIdPrefixedSpans, parser);
            traces = parser.finish();
        }
        PatchTracesRequest request = PatchTracesRequest.newBuilder().setProjectId(this.projectId).setTraces(traces).build();
        return new PatchTracesCall(request).map(EmptyToVoid.INSTANCE);
    }

    public CheckResult check() {
        return CheckResult.OK;
    }

    public final String toString() {
        return "StackdriverSender{" + this.projectId + "}";
    }

    public void close() {
        if (!this.shutdownChannelOnClose) {
            return;
        }
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        ((ManagedChannel)this.channel).shutdownNow();
    }

    static enum EmptyToVoid implements Call.Mapper<Empty, Void>
    {
        INSTANCE{

            public Void map(Empty empty) {
                return null;
            }
        };

    }

    final class PatchTracesCall
    extends UnaryClientCall<PatchTracesRequest, Empty> {
        PatchTracesCall(PatchTracesRequest request) {
            super(StackdriverSender.this.channel, TraceServiceGrpc.METHOD_PATCH_TRACES, StackdriverSender.this.callOptions, request);
        }

        public String toString() {
            return "PatchTracesCall{" + this.request() + "}";
        }

        public PatchTracesCall clone() {
            return new PatchTracesCall((PatchTracesRequest)this.request());
        }
    }

    public static final class Builder {
        final Channel channel;
        String projectId;
        CallOptions callOptions = CallOptions.DEFAULT;
        boolean shutdownChannelOnClose;

        Builder(Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel == null");
            }
            this.channel = channel;
        }

        public Builder projectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("projectId == null");
            }
            this.projectId = projectId;
            return this;
        }

        public Builder callOptions(CallOptions callOptions) {
            if (callOptions == null) {
                throw new NullPointerException("callOptions == null");
            }
            this.callOptions = callOptions;
            return this;
        }

        public StackdriverSender build() {
            if (this.projectId == null) {
                throw new NullPointerException("projectId == null");
            }
            return new StackdriverSender(this);
        }
    }
}

