/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.stackdriver;

import com.google.devtools.cloudtrace.v1.TraceSpan;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.List;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.Encoding;
import zipkin2.translation.stackdriver.SpanTranslator;

public enum StackdriverEncoder implements BytesEncoder<Span>
{
    V1{

        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        public int sizeInBytes(Span input) {
            return 32 + this.translate(input).getSerializedSize();
        }

        public byte[] encode(Span span) {
            int i;
            TraceSpan translated = this.translate(span);
            byte[] result = new byte[32 + translated.getSerializedSize()];
            String traceId = span.traceId();
            if (traceId.length() == 16) {
                for (i = 0; i < 16; ++i) {
                    result[i] = 48;
                }
                for (i = 0; i < 16; ++i) {
                    result[i + 16] = (byte)traceId.charAt(i);
                }
            } else {
                for (i = 0; i < 32; ++i) {
                    result[i] = (byte)traceId.charAt(i);
                }
            }
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])result, (int)32, (int)(result.length - 32));
            try {
                translated.writeTo(output);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return result;
        }

        TraceSpan translate(Span span) {
            return SpanTranslator.translate((TraceSpan.Builder)TraceSpan.newBuilder(), (Span)span).build();
        }

        public byte[] encodeList(List<Span> spans) {
            throw new UnsupportedOperationException("used in rest api; unused in reporter and collector");
        }
    };

}

