/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.propagation.stackdriver;

import brave.internal.HexCodec;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.propagation.stackdriver.StackdriverTracePropagation;

final class XCloudTraceContextExtractor<C, K>
implements TraceContext.Extractor<C> {
    static final Logger LOG = Logger.getLogger(XCloudTraceContextExtractor.class.getName());
    final StackdriverTracePropagation<K> propagation;
    final Propagation.Getter<C, K> getter;

    XCloudTraceContextExtractor(StackdriverTracePropagation<K> propagation, Propagation.Getter<C, K> getter) {
        this.propagation = propagation;
        this.getter = getter;
    }

    public TraceContextOrSamplingFlags extract(C carrier) {
        String[] tokens;
        long[] traceId;
        if (carrier == null) {
            throw new NullPointerException("carrier == null");
        }
        TraceContextOrSamplingFlags result = TraceContextOrSamplingFlags.EMPTY;
        String xCloudTraceContext = this.getter.get(carrier, this.propagation.getTraceIdKey());
        if (xCloudTraceContext != null && (traceId = XCloudTraceContextExtractor.convertHexTraceIdToLong((tokens = xCloudTraceContext.split("/"))[0])) != null) {
            long spanId = 0L;
            Boolean traceTrue = null;
            if (tokens.length >= 2) {
                String[] traceOptionTokens = tokens[1].split(";");
                if (traceOptionTokens.length >= 1 && !traceOptionTokens[0].isEmpty()) {
                    spanId = XCloudTraceContextExtractor.parseUnsignedLong(traceOptionTokens[0]);
                }
                if (traceOptionTokens.length >= 2) {
                    traceTrue = XCloudTraceContextExtractor.extractTraceTrueFromToken(traceOptionTokens[1]);
                }
            }
            result = spanId == 0L ? TraceContextOrSamplingFlags.create((TraceIdContext)TraceIdContext.newBuilder().traceIdHigh(traceId[0]).traceId(traceId[1]).sampled(traceTrue).build()) : TraceContextOrSamplingFlags.create((TraceContext)TraceContext.newBuilder().traceIdHigh(traceId[0]).traceId(traceId[1]).spanId(spanId).sampled(traceTrue).build());
        }
        return result;
    }

    private static long[] convertHexTraceIdToLong(String hexTraceId) {
        long[] result = new long[2];
        int length = hexTraceId.length();
        if (length != 32) {
            return null;
        }
        int traceIdIndex = Math.max(0, length - 16);
        result[0] = HexCodec.lenientLowerHexToUnsignedLong((CharSequence)hexTraceId, (int)0, (int)traceIdIndex);
        if (result[0] == 0L) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(hexTraceId + " is not a lower hex string.");
            }
            return null;
        }
        result[1] = HexCodec.lenientLowerHexToUnsignedLong((CharSequence)hexTraceId, (int)traceIdIndex, (int)length);
        if (result[1] == 0L) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(hexTraceId + " is not a lower hex string.");
            }
            return null;
        }
        return result;
    }

    static long parseUnsignedLong(String input) throws NumberFormatException {
        if (input == null) {
            throw new NumberFormatException("input == null");
        }
        int len = input.length();
        if (len == 0) {
            throw new NumberFormatException("empty input");
        }
        if (len > 20) {
            throw new NumberFormatException("too long for uint64: " + input);
        }
        if (len <= 18) {
            return Long.parseLong(input);
        }
        long left = Long.parseLong(input.substring(0, 18));
        int digit19 = XCloudTraceContextExtractor.digitAt(input, 18);
        int rightDigits = 20 - len;
        if (rightDigits == 1) {
            return left * 10L + (long)digit19;
        }
        int digit20 = XCloudTraceContextExtractor.digitAt(input, 19);
        int right = digit19 * 10 + digit20;
        if (left > 184467440737095516L || left == 184467440737095516L && right > 15) {
            throw new NumberFormatException("out of range for uint64: " + input);
        }
        return left * 100L + (long)right;
    }

    private static Boolean extractTraceTrueFromToken(String traceTrueToken) {
        int optionIndex = traceTrueToken.indexOf("o=");
        Boolean result = null;
        if (optionIndex != -1 && optionIndex + 2 < traceTrueToken.length()) {
            char traceTrueOption = traceTrueToken.charAt(optionIndex + 2);
            if (traceTrueOption == '1') {
                result = true;
            } else if (traceTrueOption == '0') {
                result = false;
            }
        }
        return result;
    }

    private static int digitAt(String input, int position) {
        if (input.length() <= position) {
            throw new NumberFormatException("position out of bounds");
        }
        switch (input.charAt(position)) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        throw new NumberFormatException("char at position " + position + "(" + input.charAt(position) + ") isn't a number");
    }
}

