/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.RecyclableBuffers;

public class ProtobufSpanDecoder {
    static final Logger LOG = Logger.getLogger(ProtobufSpanDecoder.class.getName());
    static final boolean DEBUG = false;
    static final int MAP_KEY_KEY = 10;
    static final int MAP_VALUE_KEY = 18;
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static boolean decodeTag(CodedInputStream input, Span.Builder span) throws IOException {
        String key = null;
        String value = "";
        boolean done = false;
        block5: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block5;
                }
                case 10: {
                    key = input.readStringRequireUtf8();
                    continue block5;
                }
                case 18: {
                    value = input.readStringRequireUtf8();
                    continue block5;
                }
            }
            ProtobufSpanDecoder.logAndSkip(input, tag);
        }
        if (key == null) {
            return false;
        }
        span.putTag(key, value);
        return true;
    }

    static boolean decodeAnnotation(CodedInputStream input, Span.Builder span) throws IOException {
        long timestamp = 0L;
        String value = null;
        boolean done = false;
        block5: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block5;
                }
                case 9: {
                    timestamp = input.readFixed64();
                    continue block5;
                }
                case 18: {
                    value = input.readStringRequireUtf8();
                    continue block5;
                }
            }
            ProtobufSpanDecoder.logAndSkip(input, tag);
        }
        if (timestamp == 0L || value == null) {
            return false;
        }
        span.addAnnotation(timestamp, value);
        return true;
    }

    private static Endpoint decodeEndpoint(CodedInputStream input) throws IOException {
        Endpoint.Builder endpoint = Endpoint.newBuilder();
        boolean done = false;
        block6: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block6;
                }
                case 10: {
                    endpoint.serviceName(input.readStringRequireUtf8());
                    continue block6;
                }
                case 18: 
                case 26: {
                    endpoint.parseIp(input.readByteArray());
                    continue block6;
                }
                case 32: {
                    endpoint.port(input.readInt32());
                    continue block6;
                }
            }
            ProtobufSpanDecoder.logAndSkip(input, tag);
        }
        return endpoint.build();
    }

    public static Span decodeOne(CodedInputStream input) throws IOException {
        Span.Builder span = Span.newBuilder();
        boolean done = false;
        while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    break;
                }
                case 10: {
                    span.traceId(ProtobufSpanDecoder.readHexString(input));
                    break;
                }
                case 18: {
                    span.parentId(ProtobufSpanDecoder.readHexString(input));
                    break;
                }
                case 26: {
                    span.id(ProtobufSpanDecoder.readHexString(input));
                    break;
                }
                case 32: {
                    int kind = input.readEnum();
                    if (kind == 0 || kind > Span.Kind.values().length) break;
                    span.kind(Span.Kind.values()[kind - 1]);
                    break;
                }
                case 42: {
                    span.name(input.readStringRequireUtf8());
                    break;
                }
                case 49: {
                    span.timestamp(input.readFixed64());
                    break;
                }
                case 56: {
                    span.duration(input.readUInt64());
                    break;
                }
                case 66: {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    span.localEndpoint(ProtobufSpanDecoder.decodeEndpoint(input));
                    input.checkLastTagWas(0);
                    input.popLimit(oldLimit);
                    break;
                }
                case 74: {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    span.remoteEndpoint(ProtobufSpanDecoder.decodeEndpoint(input));
                    input.checkLastTagWas(0);
                    input.popLimit(oldLimit);
                    break;
                }
                case 82: {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    ProtobufSpanDecoder.decodeAnnotation(input, span);
                    input.checkLastTagWas(0);
                    input.popLimit(oldLimit);
                    break;
                }
                case 90: {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    ProtobufSpanDecoder.decodeTag(input, span);
                    input.checkLastTagWas(0);
                    input.popLimit(oldLimit);
                    break;
                }
                case 96: {
                    span.debug(input.readBool());
                    break;
                }
                case 104: {
                    span.shared(input.readBool());
                    break;
                }
                default: {
                    ProtobufSpanDecoder.logAndSkip(input, tag);
                }
            }
        }
        return span.build();
    }

    public static List<Span> decodeList(byte[] spans) {
        return ProtobufSpanDecoder.decodeList(CodedInputStream.newInstance((byte[])spans));
    }

    public static List<Span> decodeList(ByteBuffer spans) {
        return ProtobufSpanDecoder.decodeList(CodedInputStream.newInstance((ByteBuffer)spans));
    }

    public static List<Span> decodeList(CodedInputStream input) {
        ArrayList<Span> spans = new ArrayList<Span>();
        try {
            boolean done = false;
            block6: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block6;
                    }
                    case 10: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        spans.add(ProtobufSpanDecoder.decodeOne(input));
                        input.checkLastTagWas(0);
                        input.popLimit(oldLimit);
                        continue block6;
                    }
                }
                ProtobufSpanDecoder.logAndSkip(input, tag);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return spans;
    }

    private static String readHexString(CodedInputStream input) throws IOException {
        int size = input.readRawVarint32();
        int length = size * 2;
        if (length > 32) {
            throw new AssertionError((Object)("hex field greater than 32 chars long: " + length));
        }
        char[] result = RecyclableBuffers.shortStringBuffer();
        for (int i = 0; i < length; i += 2) {
            byte b = input.readRawByte();
            result[i] = HEX_DIGITS[b >> 4 & 0xF];
            result[i + 1] = HEX_DIGITS[b & 0xF];
        }
        return new String(result, 0, length);
    }

    static void logAndSkip(CodedInputStream input, int tag) throws IOException {
        input.skipField(tag);
    }
}

