/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.ReadBuffer;

public final class JacksonSpanDecoder {
    static final JsonFactory JSON_FACTORY = new JsonFactory();

    public static List<Span> decodeList(byte[] spans) {
        try {
            return JacksonSpanDecoder.decodeList(JSON_FACTORY.createParser(spans));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<Span> decodeList(ByteBuffer spans) {
        try {
            return JacksonSpanDecoder.decodeList(JSON_FACTORY.createParser((InputStream)ReadBuffer.wrapUnsafe((ByteBuffer)spans)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Span decodeOne(byte[] span) {
        try {
            return JacksonSpanDecoder.decodeOne(JSON_FACTORY.createParser(span));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Span decodeOne(ByteBuffer span) {
        try {
            return JacksonSpanDecoder.decodeOne(JSON_FACTORY.createParser((InputStream)ReadBuffer.wrapUnsafe((ByteBuffer)span)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static List<Span> decodeList(JsonParser jsonParser) {
        ArrayList<Span> out = new ArrayList<Span>();
        try {
            if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
                throw new IOException("Not a valid JSON array, start token: " + jsonParser.currentToken());
            }
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                out.add(JacksonSpanDecoder.parseSpan(jsonParser));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out;
    }

    static Span decodeOne(JsonParser jsonParser) {
        try {
            if (!jsonParser.hasCurrentToken()) {
                jsonParser.nextToken();
            }
            return JacksonSpanDecoder.parseSpan(jsonParser);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Span parseSpan(JsonParser jsonParser) throws IOException {
        if (!jsonParser.isExpectedStartObjectToken()) {
            throw new IOException("Not a valid JSON object, start token: " + jsonParser.currentToken());
        }
        Span.Builder result = Span.newBuilder();
        block30: while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonParser.currentName();
            JsonToken value = jsonParser.nextToken();
            if (value == JsonToken.VALUE_NULL) continue;
            switch (fieldName) {
                case "traceId": {
                    result.traceId(jsonParser.getValueAsString());
                    continue block30;
                }
                case "parentId": {
                    result.parentId(jsonParser.getValueAsString());
                    continue block30;
                }
                case "id": {
                    result.id(jsonParser.getValueAsString());
                    continue block30;
                }
                case "kind": {
                    result.kind(Span.Kind.valueOf((String)jsonParser.getValueAsString()));
                    continue block30;
                }
                case "name": {
                    result.name(jsonParser.getValueAsString());
                    continue block30;
                }
                case "timestamp": {
                    result.timestamp(jsonParser.getValueAsLong());
                    continue block30;
                }
                case "duration": {
                    result.duration(jsonParser.getValueAsLong());
                    continue block30;
                }
                case "localEndpoint": {
                    result.localEndpoint(JacksonSpanDecoder.parseEndpoint(jsonParser));
                    continue block30;
                }
                case "remoteEndpoint": {
                    result.remoteEndpoint(JacksonSpanDecoder.parseEndpoint(jsonParser));
                    continue block30;
                }
                case "annotations": {
                    if (!jsonParser.isExpectedStartArrayToken()) {
                        throw new IOException("Invalid span, expecting annotations array start, got: " + value);
                    }
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        Annotation a = JacksonSpanDecoder.parseAnnotation(jsonParser);
                        result.addAnnotation(a.timestamp(), a.value());
                    }
                    continue block30;
                }
                case "tags": {
                    if (value != JsonToken.START_OBJECT) {
                        throw new IOException("Invalid span, expecting tags object, got: " + value);
                    }
                    while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                        result.putTag(jsonParser.currentName(), jsonParser.nextTextValue());
                    }
                    continue block30;
                }
                case "debug": {
                    result.debug(jsonParser.getBooleanValue());
                    continue block30;
                }
                case "shared": {
                    result.shared(jsonParser.getBooleanValue());
                    continue block30;
                }
            }
            jsonParser.skipChildren();
        }
        return result.build();
    }

    static Endpoint parseEndpoint(JsonParser jsonParser) throws IOException {
        if (!jsonParser.isExpectedStartObjectToken()) {
            throw new IOException("Not a valid JSON object, start token: " + jsonParser.currentToken());
        }
        String serviceName = null;
        String ipv4 = null;
        String ipv6 = null;
        int port = 0;
        block12: while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonParser.currentName();
            JsonToken value = jsonParser.nextToken();
            if (value == JsonToken.VALUE_NULL) continue;
            switch (fieldName) {
                case "serviceName": {
                    serviceName = jsonParser.getValueAsString();
                    continue block12;
                }
                case "ipv4": {
                    ipv4 = jsonParser.getValueAsString();
                    continue block12;
                }
                case "ipv6": {
                    ipv6 = jsonParser.getValueAsString();
                    continue block12;
                }
                case "port": {
                    port = jsonParser.getValueAsInt();
                    continue block12;
                }
            }
            jsonParser.skipChildren();
        }
        if (serviceName == null && ipv4 == null && ipv6 == null && port == 0) {
            return null;
        }
        return Endpoint.newBuilder().serviceName(serviceName).ip(ipv4).ip(ipv6).port(port).build();
    }

    static Annotation parseAnnotation(JsonParser jsonParser) throws IOException {
        if (!jsonParser.isExpectedStartObjectToken()) {
            throw new IOException("Not a valid JSON object, start token: " + jsonParser.currentToken());
        }
        long timestamp = 0L;
        String value = null;
        block8: while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName;
            switch (fieldName = jsonParser.currentName()) {
                case "timestamp": {
                    timestamp = jsonParser.getValueAsLong();
                    continue block8;
                }
                case "value": {
                    value = jsonParser.getValueAsString();
                    continue block8;
                }
            }
            jsonParser.skipChildren();
        }
        if (timestamp == 0L || value == null) {
            throw new IllegalStateException("Incomplete annotation at " + jsonParser.currentToken());
        }
        return Annotation.create((long)timestamp, value);
    }
}

