/*
 * Decompiled with CFR 0.152.
 */
package zipkin2;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.Endpoint;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=2)
public class EndpointBenchmarks {
    static final String IPV4 = "43.0.192.2";
    static final String IPV6 = "2001:db8::c001";
    static final InetAddress IPV4_ADDR;
    static final InetAddress IPV6_ADDR;
    Endpoint.Builder builder = Endpoint.newBuilder();

    @Benchmark
    public boolean parseIpv4_literal() {
        return this.builder.parseIp(IPV4);
    }

    @Benchmark
    public boolean parseIpv4_addr() {
        return this.builder.parseIp(IPV4_ADDR);
    }

    @Benchmark
    public boolean parseIpv4_bytes() {
        return this.builder.parseIp(IPV4_ADDR.getAddress());
    }

    @Benchmark
    public boolean parseIpv6_literal() {
        return this.builder.parseIp(IPV6);
    }

    @Benchmark
    public boolean parseIpv6_addr() {
        return this.builder.parseIp(IPV6_ADDR);
    }

    @Benchmark
    public boolean parseIpv6_bytes() {
        return this.builder.parseIp(IPV6_ADDR.getAddress());
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().addProfiler("gc").include(".*" + EndpointBenchmarks.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    static {
        try {
            IPV4_ADDR = Inet4Address.getByName(IPV4);
            IPV6_ADDR = Inet6Address.getByName(IPV6);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }
}

