/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.aws.elasticsearch;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.SessionProtocol;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.module.aws.elasticsearch.AWSCredentials;
import zipkin.module.aws.elasticsearch.AWSSignatureVersion4;
import zipkin.module.aws.elasticsearch.ElasticsearchDomainEndpoint;
import zipkin.module.aws.elasticsearch.ZipkinElasticsearchAwsStorageProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinElasticsearchAwsStorageProperties.class})
@Conditional(value={AwsMagic.class})
class ZipkinElasticsearchAwsStorageModule {
    static final String QUALIFIER = "zipkinElasticsearch";
    static final ObjectMapper JSON = new ObjectMapper();
    static final Pattern AWS_URL = Pattern.compile("^https://[^.]+\\.([^.]+)\\.es\\.amazonaws\\.com", 2);
    static final Logger log = Logger.getLogger(ZipkinElasticsearchAwsStorageModule.class.getName());

    ZipkinElasticsearchAwsStorageModule() {
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @Conditional(value={AwsDomainSetCondition.class})
    Supplier<EndpointGroup> esInitialEndpoints(Function<EndpointGroup, WebClient> clientFactory, String region, ZipkinElasticsearchAwsStorageProperties aws) {
        return new ElasticsearchDomainEndpoint(clientFactory, Endpoint.of((String)("es." + region + ".amazonaws.com"), (int)443), region, aws.getDomain());
    }

    @Bean
    @Conditional(value={AwsDomainSetCondition.class})
    @Qualifier(value="zipkinElasticsearch")
    SessionProtocol esSessionProtocol() {
        return SessionProtocol.HTTPS;
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    Consumer<ClientOptionsBuilder> awsSignatureVersion4(String region, AWSCredentials.Provider credentials) {
        Function<HttpClient, HttpClient> decorator = AWSSignatureVersion4.newDecorator(region, credentials);
        return client -> client.decorator(decorator);
    }

    @Bean
    String region(@Value(value="${zipkin.storage.elasticsearch.hosts:}") String hosts, ZipkinElasticsearchAwsStorageProperties aws) {
        hosts = ZipkinElasticsearchAwsStorageProperties.emptyToNull(hosts);
        String domain = aws.getDomain();
        if (hosts != null && domain != null) {
            log.warning("Expected exactly one of hosts or domain: instead saw hosts '%s' and domain '%s'. Ignoring hosts and proceeding to look for domain. Either unset ES_HOSTS or ES_AWS_DOMAIN to suppress this message.".formatted(hosts, domain));
        }
        if (aws.getRegion() != null) {
            return aws.getRegion();
        }
        if (domain != null) {
            return new DefaultAwsRegionProviderChain().getRegion();
        }
        if (hosts != null) {
            String awsRegion = ZipkinElasticsearchAwsStorageModule.regionFromAwsUrls(hosts);
            if (awsRegion == null) {
                throw new IllegalArgumentException("Couldn't find region in " + hosts);
            }
            return awsRegion;
        }
        throw new AssertionError((Object)(AwsMagic.class.getName() + " should ensure this line isn't reached"));
    }

    @Bean
    @ConditionalOnMissingBean
    AWSCredentials.Provider credentials() {
        return new AWSCredentials.Provider(){
            final AWSCredentialsProvider delegate = new DefaultAWSCredentialsProviderChain();

            @Override
            public AWSCredentials get() {
                String string;
                com.amazonaws.auth.AWSCredentials result = this.delegate.getCredentials();
                if (result instanceof AWSSessionCredentials) {
                    AWSSessionCredentials awssc = (AWSSessionCredentials)result;
                    string = awssc.getSessionToken();
                } else {
                    string = null;
                }
                String sessionToken = string;
                return new AWSCredentials(result.getAWSAccessKeyId(), result.getAWSSecretKey(), sessionToken);
            }
        };
    }

    static String regionFromAwsUrls(String hosts) {
        String awsRegion = null;
        for (String url : hosts.split(",", 100)) {
            Matcher matcher = AWS_URL.matcher(url);
            if (matcher.find()) {
                String matched = matcher.group(1);
                if (awsRegion != null) {
                    throw new IllegalArgumentException("too many regions: saw '" + awsRegion + "' and '" + matched + "'");
                }
                awsRegion = matcher.group(1);
                continue;
            }
            if (awsRegion == null) continue;
            throw new IllegalArgumentException("mismatched regions; saw '" + awsRegion + "' but none found in '" + url + "'");
        }
        return awsRegion;
    }

    static final class AwsMagic
    implements Condition {
        AwsMagic() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata md) {
            Environment env = condition.getEnvironment();
            String hosts = ZipkinElasticsearchAwsStorageProperties.emptyToNull(env.getProperty("zipkin.storage.elasticsearch.hosts"));
            String domain = ZipkinElasticsearchAwsStorageProperties.emptyToNull(env.getProperty("zipkin.storage.elasticsearch.aws.domain"));
            if (hosts == null && domain == null) {
                return false;
            }
            return domain != null || ZipkinElasticsearchAwsStorageModule.regionFromAwsUrls(hosts) != null;
        }
    }

    static final class AwsDomainSetCondition
    extends SpringBootCondition {
        static final String PROPERTY_NAME = "zipkin.storage.elasticsearch.aws.domain";

        AwsDomainSetCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String domain = context.getEnvironment().getProperty(PROPERTY_NAME);
            return domain == null || domain.isEmpty() ? ConditionOutcome.noMatch((String)"zipkin.storage.elasticsearch.aws.domain isn't set") : ConditionOutcome.match();
        }
    }
}

