/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.aws.sqs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.module.aws.sqs.ZipkinSQSCollectorModule;
import zipkin.module.aws.sqs.ZipkinSQSCollectorProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinSQSCollectorProperties.class})
@Conditional(value={ZipkinSQSCollectorModule.SQSSetCondition.class})
class ZipkinSQSCredentialsConfiguration {
    @Autowired(required=false)
    private AWSSecurityTokenService securityTokenService;

    ZipkinSQSCredentialsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={STSSetCondition.class})
    AWSSecurityTokenService securityTokenService(ZipkinSQSCollectorProperties properties) {
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(ZipkinSQSCredentialsConfiguration.getDefaultCredentialsProvider(properties))).withRegion(properties.awsStsRegion)).build();
    }

    @Bean
    @ConditionalOnMissingBean
    AWSCredentialsProvider credentialsProvider(ZipkinSQSCollectorProperties properties) {
        if (this.securityTokenService != null) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(properties.awsStsRoleArn, "zipkin-server").withStsClient(this.securityTokenService).build();
        }
        return ZipkinSQSCredentialsConfiguration.getDefaultCredentialsProvider(properties);
    }

    private static AWSCredentialsProvider getDefaultCredentialsProvider(ZipkinSQSCollectorProperties properties) {
        DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
        if (ZipkinSQSCredentialsConfiguration.notNullOrEmpty(properties.awsAccessKeyId) && ZipkinSQSCredentialsConfiguration.notNullOrEmpty(properties.awsSecretAccessKey)) {
            provider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(properties.awsAccessKeyId, properties.awsSecretAccessKey));
        }
        return provider;
    }

    private static boolean notNullOrEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    static final class STSSetCondition
    extends SpringBootCondition {
        private static final String PROPERTY_NAME = "zipkin.collector.sqs.aws-sts-role-arn";

        STSSetCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String queueUrl = context.getEnvironment().getProperty(PROPERTY_NAME);
            return STSSetCondition.isEmpty(queueUrl) ? ConditionOutcome.noMatch((String)"zipkin.collector.sqs.aws-sts-role-arn isn't set") : ConditionOutcome.match();
        }

        private static boolean isEmpty(String s) {
            return s == null || s.isEmpty();
        }
    }
}

