/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.aws.elasticsearch;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import zipkin.module.aws.elasticsearch.AWSCredentials;

final class AWSSignatureVersion4
extends SimpleDecoratingHttpClient {
    static final String EMPTY_STRING_HASH = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    static final AsciiString X_AMZ_DATE = HttpHeaderNames.of((CharSequence)"x-amz-date");
    static final AsciiString X_AMZ_SECURITY_TOKEN = HttpHeaderNames.of((CharSequence)"x-amz-security-token");
    static final AsciiString[] OTHER_CANONICAL_HEADERS = new AsciiString[]{X_AMZ_DATE, X_AMZ_SECURITY_TOKEN};
    static final String HOST_DATE = HttpHeaderNames.HOST + ";" + X_AMZ_DATE;
    static final String HOST_DATE_TOKEN = HOST_DATE + ";" + X_AMZ_SECURITY_TOKEN;
    static final String SERVICE = "es";
    static final byte[] SERVICE_BYTES = new byte[]{101, 115};
    static final byte[] AWS4_REQUEST = "aws4_request".getBytes(StandardCharsets.UTF_8);
    static final ThreadLocal<SimpleDateFormat> iso8601 = ThreadLocal.withInitial(() -> {
        SimpleDateFormat result = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        result.setTimeZone(TimeZone.getTimeZone("UTC"));
        return result;
    });
    final String region;
    final byte[] regionBytes;
    final AWSCredentials.Provider credentials;

    static Function<HttpClient, HttpClient> newDecorator(String region, AWSCredentials.Provider credentials) {
        return client -> new AWSSignatureVersion4((HttpClient)client, region, credentials);
    }

    AWSSignatureVersion4(HttpClient delegate, String region, AWSCredentials.Provider credentials) {
        super(delegate);
        if (region == null) {
            throw new NullPointerException("region == null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials == null");
        }
        this.region = region;
        this.regionBytes = region.getBytes(StandardCharsets.UTF_8);
        this.credentials = credentials;
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) {
        return HttpResponse.of((CompletableFuture)req.aggregate(AggregationOptions.usePooledObjects((ByteBufAllocator)ctx.alloc())).thenApply(aggReg -> {
            try {
                AggregatedHttpRequest signed = this.sign(ctx, (AggregatedHttpRequest)aggReg);
                HttpRequest httpRequest = signed.toHttpRequest();
                ctx.updateRequest(httpRequest);
                return (HttpResponse)((Client)this.unwrap()).execute(ctx, (Request)httpRequest);
            }
            catch (Exception e) {
                return HttpResponse.ofFailure((Throwable)e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeCanonicalString(ClientRequestContext ctx, RequestHeaders headers, HttpData payload, ByteBuf result) {
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)ctx.method().name());
        result.writeByte(10);
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)ctx.path().replace("*", "%2A").replace(",", "%2C").replace(":", "%3A"));
        result.writeByte(10);
        String query = ctx.query();
        if (query != null) {
            ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)query);
        }
        result.writeByte(10);
        ByteBuf signedHeaders = ctx.alloc().buffer();
        AWSSignatureVersion4.writeCanonicalHeaderValue(HttpHeaderNames.HOST, AWSSignatureVersion4.host(headers, ctx), signedHeaders, result);
        try {
            for (AsciiString canonicalHeader : OTHER_CANONICAL_HEADERS) {
                String value = headers.get((CharSequence)canonicalHeader);
                if (value == null) continue;
                AWSSignatureVersion4.writeCanonicalHeaderValue(canonicalHeader, value, signedHeaders, result);
            }
            result.writeByte(10);
            signedHeaders.readByte();
            result.writeBytes(signedHeaders);
        }
        finally {
            signedHeaders.release();
        }
        result.writeByte(10);
        if (!payload.isEmpty()) {
            ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)ByteBufUtil.hexDump((byte[])AWSSignatureVersion4.sha256(payload)));
        } else {
            ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)EMPTY_STRING_HASH);
        }
    }

    static void writeCanonicalHeaderValue(AsciiString canonicalHeader, String value, ByteBuf signedHeaders, ByteBuf result) {
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)canonicalHeader);
        result.writeByte(58);
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)value);
        result.writeByte(10);
        signedHeaders.writeByte(59);
        ByteBufUtil.writeUtf8((ByteBuf)signedHeaders, (CharSequence)canonicalHeader);
    }

    static void writeToSign(String timestamp, String credentialScope, ByteBuf canonicalRequest, ByteBuf result) {
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)"AWS4-HMAC-SHA256\n");
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)timestamp);
        result.writeByte(10);
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)credentialScope);
        result.writeByte(10);
        ByteBufUtil.writeUtf8((ByteBuf)result, (CharSequence)ByteBufUtil.hexDump((byte[])AWSSignatureVersion4.sha256(canonicalRequest.nioBuffer())));
    }

    static byte[] sha256(HttpData data) {
        ByteBuffer buf = data instanceof ByteBufHolder ? ((ByteBufHolder)data).content().nioBuffer() : ByteBuffer.wrap(data.array());
        return AWSSignatureVersion4.sha256(buf);
    }

    static byte[] sha256(ByteBuffer buf) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(buf);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AggregatedHttpRequest sign(ClientRequestContext ctx, AggregatedHttpRequest req) {
        AWSCredentials credentials = this.credentials.get();
        if (credentials == null) {
            throw new NullPointerException("credentials == null");
        }
        String timestamp = iso8601.get().format(new Date());
        String yyyyMMdd = timestamp.substring(0, 8);
        String credentialScope = AWSSignatureVersion4.credentialScope(yyyyMMdd, this.region);
        RequestHeadersBuilder builder = req.headers().toBuilder().set((CharSequence)X_AMZ_DATE, timestamp);
        String authority = req.authority();
        int colonIndex = -1;
        if (authority != null) {
            colonIndex = authority.indexOf(58);
        }
        if (colonIndex != -1 && (ctx.sessionProtocol().isTls() && authority.endsWith(":443") || !ctx.sessionProtocol().isTls() && authority.endsWith(":80"))) {
            builder.authority(authority.substring(0, colonIndex));
        }
        if (credentials.sessionToken != null) {
            builder.set((CharSequence)X_AMZ_SECURITY_TOKEN, credentials.sessionToken);
        }
        String signedHeaders = credentials.sessionToken == null ? HOST_DATE : HOST_DATE_TOKEN;
        ByteBuf canonicalString = ctx.alloc().heapBuffer();
        ByteBuf toSign = ctx.alloc().heapBuffer();
        try {
            AWSSignatureVersion4.writeCanonicalString(ctx, builder.build(), req.content(), canonicalString);
            AWSSignatureVersion4.writeToSign(timestamp, credentialScope, canonicalString, toSign);
            byte[] signatureKey = this.signatureKey(credentials.secretKey, yyyyMMdd);
            String signature = ByteBufUtil.hexDump((byte[])AWSSignatureVersion4.hmacSha256(signatureKey, toSign.nioBuffer()));
            String authorization = "AWS4-HMAC-SHA256 Credential=" + credentials.accessKey + '/' + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
            AggregatedHttpRequest aggregatedHttpRequest = AggregatedHttpRequest.of((RequestHeaders)builder.add((CharSequence)HttpHeaderNames.AUTHORIZATION, authorization).build(), (HttpData)req.content(), (HttpHeaders)req.trailers());
            return aggregatedHttpRequest;
        }
        finally {
            canonicalString.release();
            toSign.release();
        }
    }

    static String credentialScope(String yyyyMMdd, String region) {
        return String.format("%s/%s/%s/%s", yyyyMMdd, region, SERVICE, "aws4_request");
    }

    byte[] signatureKey(String secretKey, String yyyyMMdd) {
        byte[] kSecret = ("AWS4" + secretKey).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AWSSignatureVersion4.hmacSha256(kSecret, yyyyMMdd.getBytes(StandardCharsets.UTF_8));
        byte[] kRegion = AWSSignatureVersion4.hmacSha256(kDate, this.regionBytes);
        byte[] kService = AWSSignatureVersion4.hmacSha256(kRegion, SERVICE_BYTES);
        return AWSSignatureVersion4.hmacSha256(kService, AWS4_REQUEST);
    }

    static byte[] hmacSha256(byte[] secret, byte[] payload) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret, "HmacSHA256"));
            mac.update(payload);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static byte[] hmacSha256(byte[] secret, ByteBuffer payload) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret, "HmacSHA256"));
            mac.update(payload);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String host(RequestHeaders headers, ClientRequestContext ctx) {
        int colonIndex;
        String host = headers.get((CharSequence)HttpHeaderNames.AUTHORITY);
        if (host == null) {
            host = ctx.additionalRequestHeaders().get((CharSequence)HttpHeaderNames.AUTHORITY);
        }
        if (host == null) {
            host = ctx.endpoint().host();
        }
        if ((colonIndex = host.indexOf(58)) >= 0) {
            host = host.substring(0, colonIndex);
        }
        return host;
    }
}

