/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.awsv2;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.instrumentation.awsv2.AwsSdkTracing;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import zipkin2.internal.Nullable;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<Span> SPAN = new ExecutionAttribute(Span.class.getName());
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    TracingExecutionInterceptor(HttpTracing httpTracing) {
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        AwsSdkTracing.HttpClientRequest request = new AwsSdkTracing.HttpClientRequest(context.httpRequest());
        Span span = this.handler.handleSend((HttpClientRequest)request);
        executionAttributes.putAttribute(SPAN, (Object)span);
        String serviceName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String operation = TracingExecutionInterceptor.getAwsOperationNameFromRequestClass(context.request());
        span.name(operation).remoteServiceName(serviceName).tag("aws.service_name", serviceName).tag("aws.operation", operation);
        return request.build();
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        Span span = (Span)executionAttributes.getAttribute(SPAN);
        if (span == null) {
            return;
        }
        span.annotate("ws");
    }

    public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
        Span span = (Span)executionAttributes.getAttribute(SPAN);
        if (span == null) {
            return;
        }
        span.annotate("wr");
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Span span = (Span)executionAttributes.getAttribute(SPAN);
        if (span == null) {
            return;
        }
        this.handler.handleReceive((Object)new AwsSdkTracing.HttpClientResponse(context.httpRequest(), context.httpResponse(), null), null, span);
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Span span = (Span)executionAttributes.getAttribute(SPAN);
        if (span == null) {
            return;
        }
        Throwable error = TracingExecutionInterceptor.maybeError(context);
        AwsSdkTracing.HttpClientResponse response = context.httpResponse().map(r -> new AwsSdkTracing.HttpClientResponse(context.httpRequest().orElse(null), (SdkHttpResponse)r, error)).orElse(null);
        this.handler.handleReceive((Object)response, error, span);
    }

    @Nullable
    static Throwable maybeError(Context.FailedExecution context) {
        AwsServiceException serviceException;
        Throwable error = context.exception();
        if (error.getCause() == null && error instanceof AwsServiceException && (serviceException = (AwsServiceException)error).awsErrorDetails().errorMessage() == null) {
            return null;
        }
        return error;
    }

    static String getAwsOperationNameFromRequestClass(SdkRequest request) {
        String operation = request.getClass().getSimpleName();
        if (operation.endsWith("Request")) {
            return operation.substring(0, operation.length() - 7);
        }
        return operation;
    }
}

