/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.awsv2;

import brave.http.HttpTracing;
import brave.instrumentation.awsv2.TracingExecutionInterceptor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import zipkin2.internal.Nullable;

public final class AwsSdkTracing {
    final HttpTracing httpTracing;

    public static AwsSdkTracing create(HttpTracing httpTracing) {
        return new AwsSdkTracing(httpTracing);
    }

    AwsSdkTracing(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        this.httpTracing = httpTracing;
    }

    public ExecutionInterceptor executionInterceptor() {
        return new TracingExecutionInterceptor(this.httpTracing);
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        @Nullable
        final SdkHttpRequest request;
        final SdkHttpResponse response;
        @Nullable
        final Throwable error;

        HttpClientResponse(@Nullable SdkHttpRequest request, SdkHttpResponse response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public brave.http.HttpClientRequest request() {
            return this.request != null ? new HttpClientRequest(this.request) : null;
        }

        public Throwable error() {
            return this.error;
        }

        public Object unwrap() {
            return this.response;
        }

        public int statusCode() {
            return this.response.statusCode();
        }
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        final SdkHttpRequest delegate;
        SdkHttpRequest.Builder builder;

        HttpClientRequest(SdkHttpRequest delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.encodedPath();
        }

        public String url() {
            StringBuilder url = new StringBuilder(this.delegate.protocol()).append("://").append(this.delegate.host()).append(":").append(this.delegate.port());
            if (this.delegate.encodedPath() != null) {
                url.append(this.delegate.encodedPath());
            }
            if (this.delegate.rawQueryParameters().isEmpty()) {
                return url.toString();
            }
            url.append('?');
            Iterator entries = this.delegate.rawQueryParameters().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                url.append((String)entry.getKey());
                if (((String)entry.getKey()).isEmpty()) continue;
                url.append('=').append((String)((List)entry.getValue()).get(0));
                if (!entries.hasNext()) continue;
                url.append('&');
            }
            return url.toString();
        }

        public String header(String name) {
            List values = (List)this.delegate.headers().get(name);
            return values != null && !values.isEmpty() ? (String)values.get(0) : null;
        }

        public void header(String name, String value) {
            if (this.builder == null) {
                this.builder = (SdkHttpRequest.Builder)this.delegate.toBuilder();
            }
            this.builder.putHeader(name, value);
        }

        SdkHttpRequest build() {
            return this.builder != null ? (SdkHttpRequest)this.builder.build() : this.delegate;
        }
    }
}

