/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.awsv2;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.instrumentation.awsv2.AwsSdkTracing;
import brave.propagation.TraceContext;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<TraceContext> DEFERRED_ROOT_CONTEXT = new ExecutionAttribute("DEFERRED_ROOT_CONTEXT");
    static final ExecutionAttribute<Span> APPLICATION_SPAN = new ExecutionAttribute("APPLICATION_SPAN");
    static final ExecutionAttribute<Span> CLIENT_SPAN = new ExecutionAttribute(Span.class.getCanonicalName());
    final Tracer tracer;
    final HttpTracing httpTracing;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    TracingExecutionInterceptor(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        Span maybeDeferredRootSpan = this.tracer.nextSpan();
        if (maybeDeferredRootSpan.context().parentIdAsLong() == 0L) {
            executionAttributes.putAttribute(DEFERRED_ROOT_CONTEXT, (Object)maybeDeferredRootSpan.context());
        } else {
            executionAttributes.putAttribute(APPLICATION_SPAN, (Object)maybeDeferredRootSpan.start());
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Span applicationSpan;
        TraceContext maybeDeferredRootSpan = (TraceContext)executionAttributes.getAttribute(DEFERRED_ROOT_CONTEXT);
        AwsSdkTracing.HttpClientRequest request = new AwsSdkTracing.HttpClientRequest(context.httpRequest());
        if (maybeDeferredRootSpan != null) {
            Boolean sampled = this.httpTracing.clientRequestSampler().trySample((Object)request);
            if (sampled == null) {
                sampled = this.httpTracing.tracing().sampler().isSampled(maybeDeferredRootSpan.traceId());
            }
            applicationSpan = this.tracer.toSpan(maybeDeferredRootSpan.toBuilder().sampled(sampled).build());
            executionAttributes.putAttribute(APPLICATION_SPAN, (Object)applicationSpan.start());
        } else {
            applicationSpan = (Span)executionAttributes.getAttribute(APPLICATION_SPAN);
        }
        String serviceName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String operation = this.getAwsOperationNameFromRequestClass(context.request());
        applicationSpan.name("aws-sdk").tag("aws.service_name", serviceName).tag("aws.operation", operation);
        Span span = this.tracer.newChild(applicationSpan.context());
        this.handler.handleSend((HttpClientRequest)request, span);
        span.name(operation).remoteServiceName(serviceName);
        executionAttributes.putAttribute(CLIENT_SPAN, (Object)span);
        return request.build();
    }

    public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
        Span clientSpan = (Span)executionAttributes.getAttribute(CLIENT_SPAN);
        if (!context.httpResponse().isSuccessful()) {
            clientSpan.tag("error", context.httpResponse().statusText().orElse("Unknown AWS service error"));
        }
        this.handler.handleReceive((Object)new AwsSdkTracing.HttpClientResponse(context.httpResponse()), null, clientSpan);
        executionAttributes.putAttribute(CLIENT_SPAN, null);
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Span applicationSpan = (Span)executionAttributes.getAttribute(APPLICATION_SPAN);
        applicationSpan.finish();
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Span clientSpan = (Span)executionAttributes.getAttribute(CLIENT_SPAN);
        if (clientSpan != null) {
            this.handler.handleReceive(null, context.exception(), clientSpan);
            executionAttributes.putAttribute(CLIENT_SPAN, null);
        }
        Span applicationSpan = (Span)executionAttributes.getAttribute(APPLICATION_SPAN);
        applicationSpan.error(context.exception());
        applicationSpan.finish();
    }

    private String getAwsOperationNameFromRequestClass(SdkRequest request) {
        String operation = request.getClass().getSimpleName();
        if (operation.endsWith("Request")) {
            return operation.substring(0, operation.length() - 7);
        }
        return operation;
    }
}

