/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.aws.sqs;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.util.Map;

final class SendMessageTracingRequestHandler
extends RequestHandler2 {
    static final Propagation.Setter<Map<String, MessageAttributeValue>, String> SETTER = new Propagation.Setter<Map<String, MessageAttributeValue>, String>(){

        public void put(Map<String, MessageAttributeValue> carrier, String key, String value) {
            carrier.put(key, new MessageAttributeValue().withDataType("String").withStringValue(value));
        }
    };
    static final Propagation.Getter<Map<String, MessageAttributeValue>, String> GETTER = new Propagation.Getter<Map<String, MessageAttributeValue>, String>(){

        public String get(Map<String, MessageAttributeValue> carrier, String key) {
            return carrier.containsKey(key) ? carrier.get(key).getStringValue() : null;
        }
    };
    final Tracing tracing;
    final Tracer tracer;
    final CurrentTraceContext currentTraceContext;
    final TraceContext.Injector<Map<String, MessageAttributeValue>> injector;
    final TraceContext.Extractor<Map<String, MessageAttributeValue>> extractor;

    SendMessageTracingRequestHandler(Tracing tracing) {
        this.tracing = tracing;
        this.tracer = tracing.tracer();
        this.currentTraceContext = tracing.currentTraceContext();
        this.injector = tracing.propagation().injector(SETTER);
        this.extractor = tracing.propagation().extractor(GETTER);
    }

    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest request) {
        if (request instanceof SendMessageRequest) {
            this.handleSendMessageRequest((SendMessageRequest)request);
        } else if (request instanceof SendMessageBatchRequest) {
            this.handleSendMessageBatchRequest((SendMessageBatchRequest)request);
        }
        return request;
    }

    private void handleSendMessageRequest(SendMessageRequest request) {
        this.injectPerMessage(request.getQueueUrl(), request.getMessageAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleSendMessageBatchRequest(SendMessageBatchRequest request) {
        TraceContext maybeParent = this.currentTraceContext.get();
        Span span = maybeParent == null ? this.tracer.nextSpan() : this.tracer.newChild(maybeParent);
        span.name("publish-batch").remoteServiceName("amazon-sqs").start();
        try {
            Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
            try {
                for (SendMessageBatchRequestEntry entry : request.getEntries()) {
                    this.injectPerMessage(request.getQueueUrl(), entry.getMessageAttributes());
                }
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
            return;
        }
        finally {
            span.finish();
        }
    }

    private void injectPerMessage(String queueUrl, Map<String, MessageAttributeValue> messageAttributes) {
        TraceContext maybeParent = this.currentTraceContext.get();
        Span span = maybeParent == null ? this.tracer.nextSpan(this.extractAndClearHeaders(messageAttributes)) : this.tracer.newChild(maybeParent);
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("publish");
            span.remoteServiceName("amazon-sqs");
            span.tag("queue.url", queueUrl);
            long timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.injector.inject(span.context(), messageAttributes);
    }

    private TraceContextOrSamplingFlags extractAndClearHeaders(Map<String, MessageAttributeValue> messageAttributes) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract(messageAttributes);
        for (String propagationKey : this.tracing.propagation().keys()) {
            messageAttributes.remove(propagationKey);
        }
        return extracted;
    }
}

