/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.aws;

import brave.http.HttpClientAdapter;
import com.amazonaws.Request;
import com.amazonaws.Response;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class HttpAdapter
extends HttpClientAdapter<Request<?>, Response<?>> {
    HttpAdapter() {
    }

    public String method(Request<?> request) {
        return request.getHttpMethod().name();
    }

    public String path(Request<?> request) {
        return request.getResourcePath();
    }

    public String url(Request<?> request) {
        StringBuilder url = new StringBuilder(request.getEndpoint().toString());
        if (request.getResourcePath() != null) {
            url.append(request.getResourcePath());
        }
        if (request.getParameters().isEmpty()) {
            return url.toString();
        }
        url.append('?');
        Iterator entries = request.getParameters().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            url.append((String)entry.getKey());
            if (((String)entry.getKey()).isEmpty()) continue;
            url.append('=').append((String)((List)entry.getValue()).get(0));
            if (!entries.hasNext()) continue;
            url.append('&');
        }
        return url.toString();
    }

    public String requestHeader(Request<?> request, String name) {
        return (String)request.getHeaders().get(name);
    }

    public Integer statusCode(Response<?> response) {
        return response.getHttpResponse().getStatusCode();
    }
}

