/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.aws;

import brave.http.HttpTracing;
import brave.instrumentation.aws.TracingRequestHandler;
import brave.propagation.CurrentTraceContext;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.handlers.RequestHandler2;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AwsClientTracing {
    final HttpTracing httpTracing;
    final CurrentTraceContext currentTraceContext;

    public static AwsClientTracing create(HttpTracing httpTracing) {
        return new AwsClientTracing(httpTracing);
    }

    AwsClientTracing(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        this.httpTracing = httpTracing;
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
    }

    public <Builder extends AwsClientBuilder, Client> Client build(AwsClientBuilder<Builder, Client> builder) {
        if (builder == null) {
            throw new NullPointerException("builder == null");
        }
        if (builder instanceof AwsAsyncClientBuilder) {
            ExecutorFactory executorFactory = ((AwsAsyncClientBuilder)builder).getExecutorFactory();
            if (executorFactory == null) {
                ((AwsAsyncClientBuilder)builder).setExecutorFactory((ExecutorFactory)new TracingExecutorFactory(this.currentTraceContext, builder.getClientConfiguration()));
            } else {
                ((AwsAsyncClientBuilder)builder).setExecutorFactory((ExecutorFactory)new TracingExecutorFactoryWrapper(this.currentTraceContext, executorFactory));
            }
        }
        builder.withRequestHandlers(new RequestHandler2[]{new TracingRequestHandler(this.httpTracing)});
        return (Client)builder.build();
    }

    static final class TracingExecutorFactoryWrapper
    implements ExecutorFactory {
        final CurrentTraceContext currentTraceContext;
        final ExecutorFactory delegate;

        TracingExecutorFactoryWrapper(CurrentTraceContext currentTraceContext, ExecutorFactory delegate) {
            this.currentTraceContext = currentTraceContext;
            this.delegate = delegate;
        }

        public ExecutorService newExecutor() {
            return this.currentTraceContext.executorService(this.delegate.newExecutor());
        }
    }

    static final class TracingExecutorFactory
    implements ExecutorFactory {
        final CurrentTraceContext currentTraceContext;
        final ExecutorService executorService;

        TracingExecutorFactory(CurrentTraceContext currentTraceContext, ClientConfiguration clientConfiguration) {
            this.currentTraceContext = currentTraceContext;
            this.executorService = Executors.newFixedThreadPool(clientConfiguration.getMaxConnections());
        }

        public ExecutorService newExecutor() {
            return this.currentTraceContext.executorService(this.executorService);
        }
    }
}

