/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.statistics;

import io.prometheus.client.Histogram;

public class JournalMetrics {
    private static final Histogram SEGMENT_CREATION_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_creation_time")).help("Time spend to create a new segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_TRUNCATE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_truncate_time")).help("Time spend to truncate a segment")).labelNames(new String[]{"partition"})).register();
    private static final Histogram SEGMENT_FLUSH_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("segment_flush_time")).help("Time spend to flush segment to disk")).labelNames(new String[]{"partition"})).register();
    private final String logName;

    public JournalMetrics(String logName) {
        this.logName = logName;
    }

    public void observeSegmentCreation(Runnable segmentCreation) {
        ((Histogram.Child)SEGMENT_CREATION_TIME.labels(new String[]{this.logName})).time(segmentCreation);
    }

    public void observeSegmentFlush(Runnable segmentFlush) {
        ((Histogram.Child)SEGMENT_FLUSH_TIME.labels(new String[]{this.logName})).time(segmentFlush);
    }

    public void observeSegmentTruncation(Runnable segmentTruncation) {
        ((Histogram.Child)SEGMENT_TRUNCATE_TIME.labels(new String[]{this.logName})).time(segmentTruncation);
    }
}

