/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal.index;

import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import java.util.Map;
import java.util.TreeMap;

public class SparseJournalIndex
implements JournalIndex {
    private final int density;
    private final TreeMap<Long, Integer> positions = new TreeMap();

    public SparseJournalIndex(int density) {
        this.density = density;
    }

    @Override
    public void index(Indexed indexedEntry, int position) {
        long index = indexedEntry.index();
        if (index % (long)this.density == 0L) {
            this.positions.put(index, position);
        }
    }

    @Override
    public Position lookup(long index) {
        Map.Entry<Long, Integer> entry = this.positions.floorEntry(index);
        return entry != null ? new Position(entry.getKey(), entry.getValue()) : null;
    }

    @Override
    public void truncate(long index) {
        this.positions.tailMap(index, false).clear();
    }

    @Override
    public void compact(long index) {
        Map.Entry<Long, Integer> floorEntry = this.positions.floorEntry(index);
        if (floorEntry != null) {
            this.positions.headMap(floorEntry.getKey(), false).clear();
        }
    }
}

