/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.AbstractBytes;
import io.atomix.storage.buffer.Bytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ByteBufferBytes
extends AbstractBytes {
    protected ByteBuffer buffer;

    protected ByteBufferBytes(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public Bytes reset(ByteBuffer buffer) {
        buffer.clear();
        this.buffer = (ByteBuffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        return this;
    }

    protected abstract ByteBuffer newByteBuffer(int var1);

    @Override
    public Bytes resize(int newSize) {
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = this.newByteBuffer(newSize);
        oldBuffer.position(0).limit(oldBuffer.capacity());
        newBuffer.position(0).limit(newBuffer.capacity());
        newBuffer.put(oldBuffer);
        newBuffer.clear();
        return this.reset(newBuffer);
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    @Override
    public Bytes zero() {
        return this;
    }

    @Override
    public int size() {
        return this.buffer.capacity();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public Bytes order(ByteOrder order) {
        return this.reset(this.buffer.order(order));
    }

    private int index(int offset) {
        return offset;
    }

    @Override
    public Bytes zero(int offset) {
        for (int i = this.index(offset); i < this.buffer.capacity(); ++i) {
            this.buffer.put(i, (byte)0);
        }
        return this;
    }

    @Override
    public Bytes zero(int offset, int length) {
        for (int i = this.index(offset); i < offset + length; ++i) {
            this.buffer.put(i, (byte)0);
        }
        return this;
    }

    @Override
    public Bytes read(int position, byte[] bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            bytes[this.index((int)offset) + i] = (byte)this.readByte(position + i);
        }
        return this;
    }

    @Override
    public Bytes read(int offset, ByteBuffer dst, int dstOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dst.put(dstOffset + i, (byte)this.readByte(offset + i));
        }
        return this;
    }

    @Override
    public Bytes read(int position, Bytes bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            bytes.writeByte(offset + i, this.readByte(position + i));
        }
        return this;
    }

    @Override
    public Bytes write(int position, byte[] bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.put(position + i, bytes[this.index(offset) + i]);
        }
        return this;
    }

    @Override
    public Bytes write(int offset, ByteBuffer src, int srcOffset, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.put(offset + i, src.get(srcOffset + i));
        }
        return this;
    }

    @Override
    public Bytes write(int position, Bytes bytes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.put(position + i, (byte)bytes.readByte(offset + i));
        }
        return this;
    }

    @Override
    public int readByte(int offset) {
        return this.buffer.get(this.index(offset));
    }

    @Override
    public char readChar(int offset) {
        return this.buffer.getChar(this.index(offset));
    }

    @Override
    public short readShort(int offset) {
        return this.buffer.getShort(this.index(offset));
    }

    @Override
    public int readInt(int offset) {
        return this.buffer.getInt(this.index(offset));
    }

    @Override
    public long readLong(int offset) {
        return this.buffer.getLong(this.index(offset));
    }

    @Override
    public float readFloat(int offset) {
        return this.buffer.getFloat(this.index(offset));
    }

    @Override
    public double readDouble(int offset) {
        return this.buffer.getDouble(this.index(offset));
    }

    @Override
    public Bytes writeByte(int offset, int b) {
        this.buffer.put(this.index(offset), (byte)b);
        return this;
    }

    @Override
    public Bytes writeChar(int offset, char c) {
        this.buffer.putChar(this.index(offset), c);
        return this;
    }

    @Override
    public Bytes writeShort(int offset, short s) {
        this.buffer.putShort(this.index(offset), s);
        return this;
    }

    @Override
    public Bytes writeInt(int offset, int i) {
        this.buffer.putInt(this.index(offset), i);
        return this;
    }

    @Override
    public Bytes writeLong(int offset, long l) {
        this.buffer.putLong(this.index(offset), l);
        return this;
    }

    @Override
    public Bytes writeFloat(int offset, float f) {
        this.buffer.putFloat(this.index(offset), f);
        return this;
    }

    @Override
    public Bytes writeDouble(int offset, double d) {
        this.buffer.putDouble(this.index(offset), d);
        return this;
    }
}

