/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.ReadOnlyBuffer;
import io.atomix.storage.buffer.SlicedBuffer;
import io.atomix.storage.buffer.SwappedBuffer;
import io.atomix.utils.concurrent.ReferenceManager;
import io.atomix.utils.memory.Memory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractBuffer
implements Buffer {
    static final int DEFAULT_INITIAL_CAPACITY = 4096;
    static final int MAX_SIZE = 0x7FFFFFFA;
    protected final Bytes bytes;
    private int offset;
    private int initialCapacity;
    private int capacity;
    private int maxCapacity;
    private int position;
    private int limit = -1;
    private int mark = -1;
    private final AtomicInteger references = new AtomicInteger();
    protected final ReferenceManager<Buffer> referenceManager;
    private SwappedBuffer swap;

    protected AbstractBuffer(Bytes bytes, ReferenceManager<Buffer> referenceManager) {
        this(bytes, 0, 0, 0, referenceManager);
    }

    protected AbstractBuffer(Bytes bytes, int offset, int initialCapacity, int maxCapacity, ReferenceManager<Buffer> referenceManager) {
        if (bytes == null) {
            throw new NullPointerException("bytes cannot be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset out of bounds of the underlying byte array");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.capacity = 0;
        this.initialCapacity = initialCapacity;
        this.maxCapacity = maxCapacity;
        this.capacity(initialCapacity);
        this.referenceManager = referenceManager;
        this.references.set(1);
    }

    protected AbstractBuffer reset(int offset, int capacity, int maxCapacity) {
        this.offset = offset;
        this.capacity = 0;
        this.initialCapacity = capacity;
        this.maxCapacity = maxCapacity;
        this.capacity(this.initialCapacity);
        this.references.set(0);
        this.rewind();
        return this;
    }

    public Buffer acquire() {
        this.references.incrementAndGet();
        return this;
    }

    public boolean release() {
        if (this.references.decrementAndGet() == 0) {
            if (this.referenceManager != null) {
                this.referenceManager.release((Object)this);
            } else {
                this.bytes.close();
            }
            return true;
        }
        return false;
    }

    public int references() {
        return this.references.get();
    }

    @Override
    public Bytes bytes() {
        return this.bytes;
    }

    @Override
    public ByteOrder order() {
        return this.bytes.order();
    }

    @Override
    public Buffer order(ByteOrder order) {
        if (order == null) {
            throw new NullPointerException("order cannot be null");
        }
        if (order == this.order()) {
            return this;
        }
        if (this.swap != null) {
            return this.swap;
        }
        this.swap = new SwappedBuffer(this, this.offset, this.capacity, this.maxCapacity, this.referenceManager);
        return this.swap;
    }

    @Override
    public boolean isDirect() {
        return this.bytes.isDirect();
    }

    @Override
    public boolean isFile() {
        return this.bytes.isFile();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Buffer asReadOnlyBuffer() {
        return new ReadOnlyBuffer(this, this.referenceManager).reset(this.offset, this.capacity, this.maxCapacity).position(this.position).limit(this.limit);
    }

    @Override
    public Buffer compact() {
        this.compact(this.offset(this.position), this.offset, (this.limit != -1 ? this.limit : this.capacity) - this.offset(this.position));
        return this.clear();
    }

    protected abstract void compact(int var1, int var2, int var3);

    @Override
    public Buffer slice() {
        int maxCapacity = this.maxCapacity - this.position;
        int capacity = Math.min(Math.min(this.initialCapacity, maxCapacity), this.bytes.size() - this.offset(this.position));
        if (this.limit != -1) {
            capacity = maxCapacity = this.limit - this.position;
        }
        return new SlicedBuffer(this, this.bytes, this.offset(this.position), capacity, maxCapacity);
    }

    @Override
    public Buffer slice(int length) {
        this.checkSlice(this.position, length);
        return new SlicedBuffer(this, this.bytes, this.offset(this.position), length, length);
    }

    @Override
    public Buffer slice(int offset, int length) {
        this.checkSlice(offset, length);
        return new SlicedBuffer(this, this.bytes, this.offset(offset), length, length);
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public Buffer capacity(int capacity) {
        if (capacity > this.maxCapacity) {
            throw new IllegalArgumentException("capacity cannot be greater than maximum capacity");
        }
        if (capacity < this.capacity) {
            throw new IllegalArgumentException("capacity cannot be decreased");
        }
        if (capacity != this.capacity) {
            if (this.offset(capacity) > this.bytes.size()) {
                this.bytes.resize((int)Math.min(Memory.Util.toPow2((int)this.offset(capacity)), Integer.MAX_VALUE));
            }
            this.capacity = capacity;
        }
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public Buffer position(int position) {
        if (this.limit != -1 && position > this.limit) {
            throw new IllegalArgumentException("position cannot be greater than limit");
        }
        if (this.limit == -1 && position > this.maxCapacity) {
            throw new IllegalArgumentException("position cannot be greater than capacity");
        }
        if (position > this.capacity) {
            this.capacity((int)Math.min((long)this.maxCapacity, Memory.Util.toPow2((int)position)));
        }
        this.position = position;
        return this;
    }

    private int offset(int offset) {
        return this.offset + offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public Buffer limit(int limit) {
        if (limit > this.maxCapacity) {
            throw new IllegalArgumentException("limit cannot be greater than buffer capacity");
        }
        if (limit < -1) {
            throw new IllegalArgumentException("limit cannot be negative");
        }
        if (limit != -1 && this.offset(limit) > this.bytes.size()) {
            this.bytes.resize(this.offset(limit));
        }
        this.limit = limit;
        return this;
    }

    @Override
    public int remaining() {
        return (this.limit == -1 ? this.maxCapacity : this.limit) - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public Buffer mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public Buffer reset() {
        if (this.mark == -1) {
            throw new InvalidMarkException();
        }
        this.position = this.mark;
        return this;
    }

    @Override
    public Buffer skip(int length) {
        if (length > this.remaining()) {
            throw new IndexOutOfBoundsException("length cannot be greater than remaining bytes in the buffer");
        }
        this.position += length;
        return this;
    }

    @Override
    public Buffer clear() {
        this.position = 0;
        this.limit = -1;
        this.mark = -1;
        return this;
    }

    protected void checkOffset(int offset) {
        if (this.offset(offset) < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.limit == -1 ? offset > this.maxCapacity : offset > this.limit) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int checkSlice(int offset, int length) {
        this.checkOffset(offset);
        if (this.limit == -1) {
            if (offset + length <= this.capacity) return this.offset(offset);
            if (this.capacity >= this.maxCapacity) throw new BufferUnderflowException();
            this.capacity(this.calculateCapacity(offset + length));
            return this.offset(offset);
        } else {
            if (offset + length <= this.limit) return this.offset(offset);
            throw new BufferUnderflowException();
        }
    }

    protected int checkRead(int length) {
        this.checkRead(this.position, length);
        int previousPosition = this.position;
        this.position = previousPosition + length;
        return this.offset(previousPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int checkRead(int offset, int length) {
        this.checkOffset(offset);
        if (this.limit == -1) {
            if (offset + length <= this.capacity) return this.offset(offset);
            if (this.capacity >= this.maxCapacity) throw new BufferUnderflowException();
            if (this.offset + offset + length <= this.bytes.size()) {
                this.capacity = this.bytes.size() - this.offset;
                return this.offset(offset);
            } else {
                this.capacity(this.calculateCapacity(offset + length));
            }
            return this.offset(offset);
        } else {
            if (offset + length <= this.limit) return this.offset(offset);
            throw new BufferUnderflowException();
        }
    }

    protected int checkWrite(int length) {
        this.checkWrite(this.position, length);
        int previousPosition = this.position;
        this.position = previousPosition + length;
        return this.offset(previousPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int checkWrite(int offset, int length) {
        this.checkOffset(offset);
        if (this.limit == -1) {
            if (offset + length <= this.capacity) return this.offset(offset);
            if (this.capacity >= this.maxCapacity) throw new BufferOverflowException();
            this.capacity(this.calculateCapacity(offset + length));
            return this.offset(offset);
        } else {
            if (offset + length <= this.limit) return this.offset(offset);
            throw new BufferOverflowException();
        }
    }

    private int calculateCapacity(int minimumCapacity) {
        int newCapacity;
        for (newCapacity = Math.min(Math.max(this.capacity, 2), minimumCapacity); newCapacity < Math.min(minimumCapacity, this.maxCapacity); newCapacity <<= 1) {
        }
        return Math.min(newCapacity, this.maxCapacity);
    }

    @Override
    public Buffer zero() {
        this.bytes.zero(this.offset);
        return this;
    }

    @Override
    public Buffer zero(int offset) {
        this.checkOffset(offset);
        this.bytes.zero(this.offset(offset));
        return this;
    }

    @Override
    public Buffer zero(int offset, int length) {
        this.checkOffset(offset);
        this.bytes.zero(this.offset(offset), length);
        return this;
    }

    @Override
    public Buffer read(Buffer buffer) {
        int length = Math.min(buffer.remaining(), this.remaining());
        this.read(buffer.bytes(), buffer.offset() + buffer.position(), length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    public Buffer read(ByteBuffer buffer) {
        this.bytes.read(this.checkRead(buffer.remaining()), buffer, buffer.position(), buffer.remaining());
        return this;
    }

    @Override
    public Buffer read(Bytes bytes) {
        this.bytes.read(this.checkRead(bytes.size()), bytes, 0, bytes.size());
        return this;
    }

    @Override
    public Buffer read(Bytes bytes, int offset, int length) {
        this.bytes.read(this.checkRead(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer read(int srcOffset, Bytes bytes, int dstOffset, int length) {
        this.bytes.read(this.checkRead(srcOffset, length), bytes, dstOffset, length);
        return this;
    }

    @Override
    public Buffer read(byte[] bytes) {
        this.bytes.read(this.checkRead(bytes.length), bytes, 0, bytes.length);
        return this;
    }

    @Override
    public Buffer read(byte[] bytes, int offset, int length) {
        this.bytes.read(this.checkRead(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer read(int srcOffset, byte[] bytes, int dstOffset, int length) {
        this.bytes.read(this.checkRead(srcOffset, length), bytes, dstOffset, length);
        return this;
    }

    @Override
    public Buffer read(int offset, ByteBuffer dst, int dstOffset, int length) {
        this.bytes.read(this.checkRead(offset, length), dst, dstOffset, length);
        return this;
    }

    @Override
    public int readByte() {
        return this.bytes.readByte(this.checkRead(1));
    }

    @Override
    public int readByte(int offset) {
        return this.bytes.readByte(this.checkRead(offset, 1));
    }

    @Override
    public int readUnsignedByte() {
        return this.bytes.readUnsignedByte(this.checkRead(1));
    }

    @Override
    public int readUnsignedByte(int offset) {
        return this.bytes.readUnsignedByte(this.checkRead(offset, 1));
    }

    @Override
    public char readChar() {
        return this.bytes.readChar(this.checkRead(2));
    }

    @Override
    public char readChar(int offset) {
        return this.bytes.readChar(this.checkRead(offset, 2));
    }

    @Override
    public short readShort() {
        return this.bytes.readShort(this.checkRead(2));
    }

    @Override
    public short readShort(int offset) {
        return this.bytes.readShort(this.checkRead(offset, 2));
    }

    @Override
    public int readUnsignedShort() {
        return this.bytes.readUnsignedShort(this.checkRead(2));
    }

    @Override
    public int readUnsignedShort(int offset) {
        return this.bytes.readUnsignedShort(this.checkRead(offset, 2));
    }

    @Override
    public int readMedium() {
        return this.bytes.readMedium(this.checkRead(3));
    }

    @Override
    public int readMedium(int offset) {
        return this.bytes.readMedium(this.checkRead(offset, 3));
    }

    @Override
    public int readUnsignedMedium() {
        return this.bytes.readUnsignedMedium(this.checkRead(3));
    }

    @Override
    public int readUnsignedMedium(int offset) {
        return this.bytes.readUnsignedMedium(this.checkRead(offset, 3));
    }

    @Override
    public int readInt() {
        return this.bytes.readInt(this.checkRead(4));
    }

    @Override
    public int readInt(int offset) {
        return this.bytes.readInt(this.checkRead(offset, 4));
    }

    @Override
    public long readUnsignedInt() {
        return this.bytes.readUnsignedInt(this.checkRead(4));
    }

    @Override
    public long readUnsignedInt(int offset) {
        return this.bytes.readUnsignedInt(this.checkRead(offset, 4));
    }

    @Override
    public long readLong() {
        return this.bytes.readLong(this.checkRead(8));
    }

    @Override
    public long readLong(int offset) {
        return this.bytes.readLong(this.checkRead(offset, 8));
    }

    @Override
    public float readFloat() {
        return this.bytes.readFloat(this.checkRead(4));
    }

    @Override
    public float readFloat(int offset) {
        return this.bytes.readFloat(this.checkRead(offset, 4));
    }

    @Override
    public double readDouble() {
        return this.bytes.readDouble(this.checkRead(8));
    }

    @Override
    public double readDouble(int offset) {
        return this.bytes.readDouble(this.checkRead(offset, 8));
    }

    @Override
    public boolean readBoolean() {
        return this.bytes.readBoolean(this.checkRead(1));
    }

    @Override
    public boolean readBoolean(int offset) {
        return this.bytes.readBoolean(this.checkRead(offset, 1));
    }

    @Override
    public String readString(Charset charset) {
        if (this.readBoolean(this.position)) {
            byte[] bytes = new byte[this.readUnsignedShort(this.position + 1)];
            this.read(this.position + 1 + 2, bytes, 0, bytes.length);
            this.position += 3 + bytes.length;
            return new String(bytes, charset);
        }
        ++this.position;
        return null;
    }

    @Override
    public String readString(int offset, Charset charset) {
        if (this.readBoolean(offset)) {
            byte[] bytes = new byte[this.readUnsignedShort(offset + 1)];
            this.read(offset + 1 + 2, bytes, 0, bytes.length);
            return new String(bytes, charset);
        }
        return null;
    }

    @Override
    public String readString() {
        return this.readString(Charset.defaultCharset());
    }

    @Override
    public String readString(int offset) {
        return this.readString(offset, Charset.defaultCharset());
    }

    @Override
    public String readUTF8() {
        return this.readString(StandardCharsets.UTF_8);
    }

    @Override
    public String readUTF8(int offset) {
        return this.readString(offset, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer write(Buffer buffer) {
        int length = Math.min(buffer.remaining(), this.remaining());
        this.write(buffer.bytes(), buffer.offset() + buffer.position(), length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    public Buffer write(Bytes bytes) {
        this.bytes.write(this.checkWrite(bytes.size()), bytes, 0, bytes.size());
        return this;
    }

    @Override
    public Buffer write(Bytes bytes, int offset, int length) {
        this.bytes.write(this.checkWrite(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer write(int offset, Bytes bytes, int srcOffset, int length) {
        this.bytes.write(this.checkWrite(offset, length), bytes, srcOffset, length);
        return this;
    }

    @Override
    public Buffer write(byte[] bytes) {
        this.bytes.write(this.checkWrite(bytes.length), bytes, 0, bytes.length);
        return this;
    }

    @Override
    public Buffer write(ByteBuffer src) {
        int length = src.remaining();
        this.bytes.write(this.checkWrite(length), src, src.position(), length);
        return this;
    }

    @Override
    public Buffer write(int offset, ByteBuffer src, int srcOffset, int length) {
        this.bytes.write(this.checkWrite(offset, length), src, srcOffset, length);
        return this;
    }

    @Override
    public Buffer write(byte[] bytes, int offset, int length) {
        this.bytes.write(this.checkWrite(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer write(int offset, byte[] bytes, int srcOffset, int length) {
        this.bytes.write(this.checkWrite(offset, length), bytes, srcOffset, length);
        return this;
    }

    @Override
    public Buffer writeByte(int b) {
        this.bytes.writeByte(this.checkWrite(1), b);
        return this;
    }

    @Override
    public Buffer writeByte(int offset, int b) {
        this.bytes.writeByte(this.checkWrite(offset, 1), b);
        return this;
    }

    @Override
    public Buffer writeUnsignedByte(int b) {
        this.bytes.writeUnsignedByte(this.checkWrite(1), b);
        return this;
    }

    @Override
    public Buffer writeUnsignedByte(int offset, int b) {
        this.bytes.writeUnsignedByte(this.checkWrite(offset, 1), b);
        return this;
    }

    @Override
    public Buffer writeChar(char c) {
        this.bytes.writeChar(this.checkWrite(2), c);
        return this;
    }

    @Override
    public Buffer writeChar(int offset, char c) {
        this.bytes.writeChar(this.checkWrite(offset, 2), c);
        return this;
    }

    @Override
    public Buffer writeShort(short s) {
        this.bytes.writeShort(this.checkWrite(2), s);
        return this;
    }

    @Override
    public Buffer writeShort(int offset, short s) {
        this.bytes.writeShort(this.checkWrite(offset, 2), s);
        return this;
    }

    @Override
    public Buffer writeUnsignedShort(int s) {
        this.bytes.writeUnsignedShort(this.checkWrite(2), s);
        return this;
    }

    @Override
    public Buffer writeUnsignedShort(int offset, int s) {
        this.bytes.writeUnsignedShort(this.checkWrite(offset, 2), s);
        return this;
    }

    @Override
    public Buffer writeMedium(int m) {
        this.bytes.writeMedium(this.checkWrite(3), m);
        return this;
    }

    @Override
    public Buffer writeMedium(int offset, int m) {
        this.bytes.writeMedium(this.checkWrite(offset, 3), m);
        return this;
    }

    @Override
    public Buffer writeUnsignedMedium(int m) {
        this.bytes.writeUnsignedMedium(this.checkWrite(3), m);
        return this;
    }

    @Override
    public Buffer writeUnsignedMedium(int offset, int m) {
        this.bytes.writeUnsignedMedium(this.checkWrite(offset, 3), m);
        return this;
    }

    @Override
    public Buffer writeInt(int i) {
        this.bytes.writeInt(this.checkWrite(4), i);
        return this;
    }

    @Override
    public Buffer writeInt(int offset, int i) {
        this.bytes.writeInt(this.checkWrite(offset, 4), i);
        return this;
    }

    @Override
    public Buffer writeUnsignedInt(long i) {
        this.bytes.writeUnsignedInt(this.checkWrite(4), i);
        return this;
    }

    @Override
    public Buffer writeUnsignedInt(int offset, long i) {
        this.bytes.writeUnsignedInt(this.checkWrite(offset, 4), i);
        return this;
    }

    @Override
    public Buffer writeLong(long l) {
        this.bytes.writeLong(this.checkWrite(8), l);
        return this;
    }

    @Override
    public Buffer writeLong(int offset, long l) {
        this.bytes.writeLong(this.checkWrite(offset, 8), l);
        return this;
    }

    @Override
    public Buffer writeFloat(float f) {
        this.bytes.writeFloat(this.checkWrite(4), f);
        return this;
    }

    @Override
    public Buffer writeFloat(int offset, float f) {
        this.bytes.writeFloat(this.checkWrite(offset, 4), f);
        return this;
    }

    @Override
    public Buffer writeDouble(double d) {
        this.bytes.writeDouble(this.checkWrite(8), d);
        return this;
    }

    @Override
    public Buffer writeDouble(int offset, double d) {
        this.bytes.writeDouble(this.checkWrite(offset, 8), d);
        return this;
    }

    @Override
    public Buffer writeBoolean(boolean b) {
        this.bytes.writeBoolean(this.checkWrite(1), b);
        return this;
    }

    @Override
    public Buffer writeBoolean(int offset, boolean b) {
        this.bytes.writeBoolean(this.checkWrite(offset, 1), b);
        return this;
    }

    @Override
    public Buffer writeString(String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(this.checkWrite(1), Boolean.FALSE);
        }
        byte[] bytes = s.getBytes(charset);
        this.checkWrite(this.position, 3 + bytes.length);
        this.writeBoolean(Boolean.TRUE).writeUnsignedShort(bytes.length).write(bytes, 0, bytes.length);
        return this;
    }

    @Override
    public Buffer writeString(int offset, String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(this.checkWrite(offset, 1), Boolean.FALSE);
        }
        byte[] bytes = s.getBytes(charset);
        this.checkWrite(offset, 3 + bytes.length);
        this.writeBoolean(offset, Boolean.TRUE).writeUnsignedShort(offset + 1, bytes.length).write(offset + 1 + 2, bytes, 0, bytes.length);
        return this;
    }

    @Override
    public Buffer writeString(String s) {
        return this.writeString(s, Charset.defaultCharset());
    }

    @Override
    public Buffer writeString(int offset, String s) {
        return this.writeString(offset, s, Charset.defaultCharset());
    }

    @Override
    public Buffer writeUTF8(String s) {
        return this.writeString(s, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer writeUTF8(int offset, String s) {
        return this.writeString(offset, s, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer flush() {
        this.bytes.flush();
        return this;
    }

    @Override
    public void close() {
        this.references.set(0);
        if (this.referenceManager != null) {
            this.referenceManager.release((Object)this);
        } else {
            this.bytes.close();
        }
    }
}

