/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubclassesResolver {
    private static final Logger log = LoggerFactory.getLogger(SubclassesResolver.class);
    private ClassGraph classGraph;
    private ScanResult scanResult;

    public SubclassesResolver() {
        this(null);
    }

    public SubclassesResolver(List<String> packagesToScan, List<String> classesToScan) {
        this(SubclassesResolver.buildClassGraph(packagesToScan, classesToScan));
    }

    public SubclassesResolver(ClassGraph classGraph) {
        if (classGraph == null) {
            log.debug("Entire classpath will be scanned because SubclassesResolver is not configured. See https://github.com/mbknor/mbknor-jackson-jsonSchema#subclass-resolving-using-reflection");
            this.classGraph = new ClassGraph();
        } else {
            this.classGraph = classGraph;
        }
    }

    public ScanResult getScanResult() {
        if (this.scanResult == null) {
            this.scanResult = this.classGraph.enableClassInfo().scan();
        }
        return this.scanResult;
    }

    public List<Class<?>> getSubclasses(Class<?> clazz) {
        if (clazz.isInterface()) {
            return this.getScanResult().getClassesImplementing(clazz.getName()).loadClasses();
        }
        return this.getScanResult().getSubclasses(clazz.getName()).loadClasses();
    }

    private static ClassGraph buildClassGraph(List<String> packagesToScan, List<String> classesToScan) {
        if (packagesToScan == null && classesToScan == null) {
            return null;
        }
        ClassGraph classGraph = new ClassGraph();
        if (packagesToScan != null) {
            classGraph.whitelistPackages(packagesToScan.toArray(new String[0]));
        }
        if (classesToScan != null) {
            classGraph.whitelistClasses(classesToScan.toArray(new String[0]));
        }
        return classGraph;
    }
}

