/*
 * Decompiled with CFR 0.152.
 */
package io.wusa;

import io.wusa.GitService;
import io.wusa.IVersionFactory;
import io.wusa.RegexResolver;
import io.wusa.SemanticVersionFactory;
import io.wusa.Suffix;
import io.wusa.Version;
import io.wusa.exception.DirtyWorkingTreeException;
import io.wusa.exception.NoCurrentCommitFoundException;
import io.wusa.exception.NoCurrentTagFoundException;
import io.wusa.exception.NoIncrementerFoundException;
import io.wusa.exception.NoLastTagFoundException;
import io.wusa.exception.NoValidSemverTagFoundException;
import io.wusa.extension.Branch;
import io.wusa.extension.SemverGitPluginExtension;
import io.wusa.incrementer.VersionIncrementer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000f\u001a\u00020\bJ\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/wusa/VersionService;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "semverGitPluginExtension", "Lio/wusa/extension/SemverGitPluginExtension;", "buildInitialVersion", "Lio/wusa/Version;", "versionFactory", "Lio/wusa/IVersionFactory;", "buildInitialVersionForTag", "buildInitialVersionWithNoTag", "getCurrentVersion", "getLastVersion", "getVersion", "handleDirtyWorkingTree", "handleNoCurrentTagFound", "incrementVersion", "version", "semver-git-plugin"})
public final class VersionService {
    private final SemverGitPluginExtension semverGitPluginExtension;
    private Project project;

    @NotNull
    public final Version getVersion() throws GradleException {
        Version version;
        IVersionFactory versionFactory = new SemanticVersionFactory();
        try {
            version = this.getCurrentVersion(versionFactory);
        }
        catch (IllegalArgumentException ex) {
            throw (Throwable)new GradleException("The current tag is not a semantic version.");
        }
        catch (NoCurrentTagFoundException ex) {
            version = this.handleNoCurrentTagFound(versionFactory, this.project);
        }
        catch (DirtyWorkingTreeException ex) {
            version = this.handleDirtyWorkingTree(versionFactory, this.project);
        }
        return version;
    }

    private final Version handleDirtyWorkingTree(IVersionFactory versionFactory, Project project) throws GradleException {
        Version version;
        try {
            Version lastVersion = this.getLastVersion(versionFactory);
            version = this.incrementVersion(lastVersion, project);
        }
        catch (NoValidSemverTagFoundException ex) {
            throw (Throwable)new GradleException(ex.getLocalizedMessage());
        }
        catch (NoIncrementerFoundException ex) {
            throw (Throwable)new GradleException(ex.getLocalizedMessage());
        }
        catch (NoLastTagFoundException ex) {
            version = this.buildInitialVersion(versionFactory);
        }
        return version;
    }

    private final Version handleNoCurrentTagFound(IVersionFactory versionFactory, Project project) throws GradleException {
        Version version;
        try {
            Version lastVersion = this.getLastVersion(versionFactory);
            version = this.incrementVersion(lastVersion, project);
        }
        catch (NoValidSemverTagFoundException ex) {
            throw (Throwable)new GradleException(ex.getLocalizedMessage());
        }
        catch (NoIncrementerFoundException ex) {
            throw (Throwable)new GradleException(ex.getLocalizedMessage());
        }
        catch (NoLastTagFoundException ex) {
            version = this.buildInitialVersion(versionFactory);
        }
        return version;
    }

    private final Version buildInitialVersion(IVersionFactory versionFactory) {
        Version version;
        try {
            version = this.buildInitialVersionForTag(versionFactory);
        }
        catch (NoCurrentCommitFoundException ex) {
            version = this.buildInitialVersionWithNoTag();
        }
        return version;
    }

    private final Version buildInitialVersionWithNoTag() {
        return new Version(0, 1, 0, "", "", null);
    }

    private final Version buildInitialVersionForTag(IVersionFactory versionFactory) {
        String sha = GitService.Companion.currentCommit(this.project, true);
        boolean isDirty = GitService.Companion.isDirty(this.project);
        int count = GitService.Companion.count(this.project);
        Version version = versionFactory.createFromString(this.semverGitPluginExtension.getInitialVersion());
        version.setSuffix(new Suffix(count, sha, isDirty));
        return version;
    }

    private final Version getLastVersion(IVersionFactory versionFactory) {
        String tagPrefix = this.semverGitPluginExtension.getTagPrefix();
        String lastTag = GitService.Companion.lastTag(this.project, tagPrefix, this.semverGitPluginExtension.getTagType());
        if (!StringsKt.startsWith$default((String)lastTag, (String)tagPrefix, (boolean)false, (int)2, null)) {
            throw (Throwable)new NoCurrentTagFoundException(lastTag + " doesn't match " + tagPrefix);
        }
        String string = lastTag;
        int n = tagPrefix.length();
        IVersionFactory iVersionFactory = versionFactory;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string3;
        return iVersionFactory.createFromString(string4);
    }

    private final Version getCurrentVersion(IVersionFactory versionFactory) {
        String tagPrefix = this.semverGitPluginExtension.getTagPrefix();
        String curTag = GitService.Companion.currentTag(this.project, tagPrefix, this.semverGitPluginExtension.getTagType());
        if (!StringsKt.startsWith$default((String)curTag, (String)tagPrefix, (boolean)false, (int)2, null)) {
            throw (Throwable)new NoCurrentTagFoundException(curTag + " doesn't match " + tagPrefix);
        }
        boolean isDirty = GitService.Companion.isDirty(this.project);
        if (isDirty) {
            throw (Throwable)new DirtyWorkingTreeException("The current working tree is dirty.");
        }
        String string = curTag;
        int n = tagPrefix.length();
        IVersionFactory iVersionFactory = versionFactory;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string3;
        return iVersionFactory.createFromString(string4);
    }

    private final Version incrementVersion(Version version, Project project) {
        Branch regexIncrementerPair;
        Branch branch = regexIncrementerPair = RegexResolver.Companion.findMatchingRegex(this.semverGitPluginExtension.getBranches(), this.semverGitPluginExtension.getInfo().getBranch().getName());
        if (branch != null) {
            Branch branch2 = branch;
            boolean bl = false;
            boolean bl2 = false;
            Branch it = branch2;
            boolean bl3 = false;
            return VersionIncrementer.Companion.getVersionIncrementerByName(regexIncrementerPair.getIncrementer()).increment(version, project);
        }
        VersionService versionService = this;
        boolean bl = false;
        boolean bl4 = false;
        VersionService $receiver = versionService;
        boolean bl5 = false;
        return VersionIncrementer.Companion.getVersionIncrementerByName("MINOR_INCREMENTER").increment(version, project);
    }

    public VersionService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Object object = this.project.getExtensions().getByType(SemverGitPluginExtension.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
        this.semverGitPluginExtension = (SemverGitPluginExtension)object;
    }
}

