/*
 * Decompiled with CFR 0.152.
 */
package io.wusa;

import io.wusa.GitCommandRunner;
import io.wusa.TagType;
import io.wusa.exception.GitException;
import io.wusa.exception.NoCurrentBranchFoundException;
import io.wusa.exception.NoCurrentCommitFoundException;
import io.wusa.exception.NoCurrentTagFoundException;
import io.wusa.exception.NoLastTagFoundException;
import java.io.File;
import java.util.List;
import kotlin.KotlinNullPointerException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/wusa/GitService;", "", "()V", "Companion", "semver-git-plugin"})
public final class GitService {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0018"}, d2={"Lio/wusa/GitService$Companion;", "", "()V", "count", "", "project", "Lorg/gradle/api/Project;", "currentBranch", "", "currentCommit", "isShort", "", "currentTag", "tagPrefix", "tagType", "Lio/wusa/TagType;", "getCommitsSinceLastTag", "", "getCurrentBranch", "getCurrentCommit", "getCurrentShortCommit", "isDirty", "isGitDifferent", "lastTag", "semver-git-plugin"})
    public static final class Companion {
        @NotNull
        public final String currentBranch(@NotNull Project project) throws NoCurrentBranchFoundException {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            try {
                string = this.getCurrentBranch(project);
            }
            catch (GitException ex) {
                throw (Throwable)new NoCurrentBranchFoundException(ex);
            }
            catch (KotlinNullPointerException ex) {
                throw (Throwable)new NoCurrentBranchFoundException(ex);
            }
            return string;
        }

        @NotNull
        public final String currentCommit(@NotNull Project project, boolean isShort) throws NoCurrentCommitFoundException {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return isShort ? this.getCurrentShortCommit(project) : this.getCurrentCommit(project);
        }

        @NotNull
        public final String currentTag(@NotNull Project project, @NotNull String tagPrefix, @NotNull TagType tagType) throws NoCurrentTagFoundException {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)tagPrefix, (String)"tagPrefix");
            Intrinsics.checkParameterIsNotNull((Object)((Object)tagType), (String)"tagType");
            String[] cmdArgs = new String[]{"describe", "--exact-match", "--match", tagPrefix + '*'};
            if (tagType == TagType.LIGHTWEIGHT) {
                cmdArgs = new String[]{"describe", "--tags", "--exact-match", "--match", tagPrefix + '*'};
            }
            try {
                File file = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
                string = GitCommandRunner.Companion.execute(file, cmdArgs);
            }
            catch (GitException ex) {
                throw (Throwable)new NoCurrentTagFoundException(ex);
            }
            return string;
        }

        @NotNull
        public static /* synthetic */ String currentTag$default(Companion companion, Project project, String string, TagType tagType, int n, Object object) throws NoCurrentTagFoundException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                tagType = TagType.ANNOTATED;
            }
            return companion.currentTag(project, string, tagType);
        }

        @NotNull
        public final String lastTag(@NotNull Project project, @NotNull String tagPrefix, @NotNull TagType tagType) throws NoLastTagFoundException {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)tagPrefix, (String)"tagPrefix");
            Intrinsics.checkParameterIsNotNull((Object)((Object)tagType), (String)"tagType");
            String[] cmdArgs = new String[]{"describe", "--abbrev=7", "--match", tagPrefix + '*'};
            if (tagType == TagType.LIGHTWEIGHT) {
                cmdArgs = new String[]{"describe", "--tags", "--abbrev=7", "--match", tagPrefix + '*'};
            }
            try {
                File file = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
                string = GitCommandRunner.Companion.execute(file, cmdArgs);
            }
            catch (GitException ex) {
                throw (Throwable)new NoLastTagFoundException(ex);
            }
            return string;
        }

        @NotNull
        public static /* synthetic */ String lastTag$default(Companion companion, Project project, String string, TagType tagType, int n, Object object) throws NoLastTagFoundException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                tagType = TagType.ANNOTATED;
            }
            return companion.lastTag(project, string, tagType);
        }

        public final boolean isDirty(@NotNull Project project) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            try {
                bl = this.isGitDifferent(project);
            }
            catch (GitException ex) {
                bl = false;
            }
            return bl;
        }

        public final int count(@NotNull Project project) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            try {
                File file = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
                String string = GitCommandRunner.Companion.execute(file, new String[]{"rev-list", "--count", "HEAD"});
                boolean bl = false;
                n = Integer.parseInt(string);
            }
            catch (GitException ex) {
                n = 0;
            }
            return n;
        }

        @NotNull
        public final List<String> getCommitsSinceLastTag(@NotNull Project project, @NotNull String tagPrefix, @NotNull TagType tagType) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)tagPrefix, (String)"tagPrefix");
            Intrinsics.checkParameterIsNotNull((Object)((Object)tagType), (String)"tagType");
            String[] cmdArgs = new String[]{"describe", "--abbrev=0", "--match", tagPrefix + '*'};
            if (tagType == TagType.LIGHTWEIGHT) {
                cmdArgs = new String[]{"describe", "--tags", "--abbrev=0", "--match", tagPrefix + '*'};
            }
            try {
                File file = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
                String lastTag = GitCommandRunner.Companion.execute(file, cmdArgs);
                File file2 = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.projectDir");
                list = StringsKt.lines((CharSequence)GitCommandRunner.Companion.execute(file2, new String[]{"log", "--pretty=format:%s %(trailers:separator=%x2c)", lastTag + "..@"}));
            }
            catch (GitException ex) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public static /* synthetic */ List getCommitsSinceLastTag$default(Companion companion, Project project, String string, TagType tagType, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                tagType = TagType.ANNOTATED;
            }
            return companion.getCommitsSinceLastTag(project, string, tagType);
        }

        private final boolean isGitDifferent(Project project) {
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
            CharSequence charSequence = GitCommandRunner.Companion.execute(file, new String[]{"status", "-s"});
            boolean bl = false;
            return !StringsKt.isBlank((CharSequence)charSequence);
        }

        private final String getCurrentCommit(Project project) {
            String string;
            try {
                File file = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
                string = GitCommandRunner.Companion.execute(file, new String[]{"rev-parse", "HEAD"});
            }
            catch (GitException ex) {
                throw (Throwable)new NoCurrentCommitFoundException(ex);
            }
            return string;
        }

        private final String getCurrentShortCommit(Project project) {
            String string;
            try {
                File file = project.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
                string = GitCommandRunner.Companion.execute(file, new String[]{"rev-parse", "--short", "HEAD"});
            }
            catch (GitException ex) {
                throw (Throwable)new NoCurrentCommitFoundException(ex);
            }
            return string;
        }

        private final String getCurrentBranch(Project project) {
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
            String head = GitCommandRunner.Companion.execute(file, new String[]{"log", "-n", "1", "--pretty=%d", "HEAD"});
            String string = "\\([grafted, ]{0,9}HEAD -> (.*?)[,|)]";
            boolean bl = false;
            MatchResult matchResult = Regex.find$default((Regex)new Regex(string), (CharSequence)head, (int)0, (int)2, null);
            if (matchResult == null) {
                Intrinsics.throwNpe();
            }
            return (String)matchResult.getGroupValues().get(1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

