/*
 * Decompiled with CFR 0.152.
 */
package io.wusa;

import io.wusa.exception.GitException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/wusa/GitCommandRunner;", "", "()V", "Companion", "semver-git-plugin"})
public final class GitCommandRunner {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J#\u0010\u000f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lio/wusa/GitCommandRunner$Companion;", "", "()V", "execute", "", "projectDir", "Ljava/io/File;", "args", "", "(Ljava/io/File;[Ljava/lang/String;)Ljava/lang/String;", "processFinishedWithoutErrors", "", "process", "Ljava/lang/Process;", "readProcessOutput", "startGitProcess", "([Ljava/lang/String;Ljava/io/File;)Ljava/lang/Process;", "waitForGitProcess", "", "semver-git-plugin"})
    public static final class Companion {
        @NotNull
        public final String execute(@NotNull File projectDir, @NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Process process = this.startGitProcess(args, projectDir);
            String output = this.readProcessOutput(process);
            this.waitForGitProcess(process);
            if (this.processFinishedWithoutErrors(process)) {
                return output;
            }
            throw (Throwable)new GitException("Executing git command failed with " + process.exitValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String readProcessOutput(Process process) {
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
            Object object = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object2 = object;
            int n = 0;
            object2 = new InputStreamReader((InputStream)object2, charset);
            n = 8192;
            boolean bl2 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl4 = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = object2;
            bl3 = false;
            Object object3 = object;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
        }

        private final boolean processFinishedWithoutErrors(Process process) {
            return process.exitValue() == 0;
        }

        private final void waitForGitProcess(Process process) {
            if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                process.destroy();
                throw (Throwable)new RuntimeException("Execution timed out: " + this);
            }
        }

        private final Process startGitProcess(String[] args, File projectDir) {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)"git");
            spreadBuilder.addSpread((Object)args);
            Process process = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])).directory(projectDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"ProcessBuilder(\"git\", *a\u2026                 .start()");
            return process;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

