/*
 * Decompiled with CFR 0.152.
 */
package io.whitesource.cure;

import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;

public class FileSecurityUtils {
    public static boolean isFileOutsideDir(@NonNull String filePath, @NonNull String baseDirPath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (baseDirPath == null) {
            throw new NullPointerException("baseDirPath is marked non-null but is null");
        }
        File file = new File(filePath);
        File baseDir = new File(baseDirPath);
        return !file.getCanonicalPath().startsWith(baseDir.getCanonicalPath());
    }

    public static String normalize(String filePath) {
        if (filePath == null) {
            return null;
        }
        return FilenameUtils.normalize((String)filePath);
    }
}

