/*
 * Decompiled with CFR 0.152.
 */
package io.whitesource.cure;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.owasp.encoder.Encode;

public class Encoder {
    private static final String LOG_ALLOW_LIST_FILE = "WssAllowListForLog.json";

    public static String escapeForbiddenCharacters(Object param, File pathToPropertiesFiles) {
        if (param == null) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            if (pathToPropertiesFiles != null && pathToPropertiesFiles.exists()) {
                AllowListProperties properties = (AllowListProperties)objectMapper.readValue(pathToPropertiesFiles, AllowListProperties.class);
                return Encoder.replaceForbiddenCharsWithSafeChar(param, properties);
            }
            return Encoder.escapeForbiddenCharacters(param);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to sanitize value", e);
        }
    }

    public static String escapeForbiddenCharacters(Object param) {
        if (param == null) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(LOG_ALLOW_LIST_FILE);
            String propertiesFileContent = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            AllowListProperties properties = (AllowListProperties)objectMapper.readValue(propertiesFileContent, AllowListProperties.class);
            return Encoder.replaceForbiddenCharsWithSafeChar(param, properties);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to sanitize value", e);
        }
    }

    private static String replaceForbiddenCharsWithSafeChar(Object param, AllowListProperties properties) {
        StringBuilder regex = new StringBuilder("[^");
        for (String expression : properties.getAllowList()) {
            regex.append(expression);
        }
        regex.append("]");
        return Encoder.formatToString(param).replaceAll(regex.toString(), properties.getSafeCharReplacement());
    }

    public static String forOsCommand(Object param) {
        if (param == null) {
            return null;
        }
        return Encoder.forOsCommand(param, new char[0]);
    }

    public static String forOsCommand(Object param, char[] charsToIgnore) {
        if (param == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : Encoder.formatToString(param).toCharArray()) {
            sb.append(Encoder.encodeCharacterForOsCommand(c, charsToIgnore));
        }
        return sb.toString();
    }

    public static String[] forLogContent(Object[] contents) {
        if (contents == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Object content : contents) {
            results.add(Encoder.forLogContent(content));
        }
        return results.toArray(new String[results.size()]);
    }

    public static String forLogContent(Object content) {
        if (content == null) {
            return null;
        }
        return Encoder.formatToString(content).replaceAll("[\n|\r|\t]", "_").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("[$]", "&dollar;");
    }

    public static <T extends Collection<String>> T forLogContent(Collection<?> contents) {
        if (contents == null) {
            return null;
        }
        HashSet<String> results = new HashSet<String>();
        for (Object content : contents) {
            results.add(Encoder.forLogContent(content));
        }
        if (contents instanceof Set) {
            return (T)new HashSet(results);
        }
        if (contents instanceof List) {
            return (T)new ArrayList(results);
        }
        return (T)results;
    }

    public static String forCrlf(Object content) {
        if (content == null) {
            return null;
        }
        return StringUtils.replaceEach((String)Encoder.formatToString(content), (String[])new String[]{"\n", "\\n", "\r", "\\r", "%0d", "%0D", "%0a", "%0A", "\u0015"}, (String[])new String[]{"", "", "", "", "", "", "", "", ""});
    }

    public static String[] forCrlf(Object[] contents) {
        if (contents == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Object content : contents) {
            results.add(Encoder.forCrlf(content));
        }
        return results.toArray(new String[results.size()]);
    }

    public static <T extends Collection<String>> T forCrlf(Collection<?> contents) {
        if (contents == null) {
            return null;
        }
        HashSet<String> results = new HashSet<String>();
        for (Object content : contents) {
            results.add(Encoder.forCrlf(content));
        }
        if (contents instanceof Set) {
            return (T)new HashSet(results);
        }
        if (contents instanceof List) {
            return (T)new ArrayList(results);
        }
        return (T)results;
    }

    public static String forJavaScriptBlockXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forJavaScriptBlock((String)Encoder.formatToString(content));
    }

    public static String forHtmlContentXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forHtmlContent((String)Encoder.formatToString(content));
    }

    public static String forHtmlAttributeXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forHtmlAttribute((String)Encoder.formatToString(content));
    }

    public static String forJavaScriptXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forJavaScript((String)Encoder.formatToString(content));
    }

    public static String forCssStringXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forCssString((String)Encoder.formatToString(content));
    }

    public static String forUriComponentXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forUriComponent((String)Encoder.formatToString(content));
    }

    public static String forCssUrlXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forCssUrl((String)Encoder.formatToString(content));
    }

    public static String forHtmlUnquotedAttributeXss(Object content) {
        if (content == null) {
            return null;
        }
        return Encode.forHtmlUnquotedAttribute((String)Encoder.formatToString(content));
    }

    public static String forJavaScriptAttributeXss(String content) {
        if (content == null) {
            return null;
        }
        return Encode.forJavaScriptAttribute((String)Encoder.formatToString(content));
    }

    private static String encodeCharacterForOsCommand(char charToEncode, char[] charsToIgnore) {
        if (new String(charsToIgnore).indexOf(charToEncode) != -1 || Encoder.isAlphaNumeric(charToEncode)) {
            return "" + charToEncode;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return "^" + charToEncode;
        }
        if (SystemUtils.IS_OS_UNIX) {
            return "\\" + charToEncode;
        }
        throw new RuntimeException("Unknown operation system type");
    }

    private static boolean isAlphaNumeric(char charToEncode) {
        return charToEncode >= '0' && charToEncode <= '9' || charToEncode >= 'A' && charToEncode <= 'Z' || charToEncode >= 'a' && charToEncode <= 'z';
    }

    private static String formatToString(Object content) {
        if (content instanceof char[]) {
            return new String((char[])content);
        }
        if (content instanceof String) {
            return (String)content;
        }
        return content.toString();
    }

    private static class AllowListProperties {
        private String safeCharReplacement;
        private List<String> allowList;

        public String getSafeCharReplacement() {
            return this.safeCharReplacement;
        }

        public List<String> getAllowList() {
            return this.allowList;
        }
    }
}

