/*
 * Decompiled with CFR 0.152.
 */
package io.vin.android.zbar;

import java.util.ArrayList;
import java.util.List;

public class Symbology {
    private int mId;
    private String mName;
    public static final Symbology NONE = new Symbology(0, "NONE");
    public static final Symbology PARTIAL = new Symbology(1, "PARTIAL");
    public static final Symbology EAN8 = new Symbology(8, "EAN8");
    public static final Symbology UPCE = new Symbology(9, "UPCE");
    public static final Symbology ISBN10 = new Symbology(10, "ISBN10");
    public static final Symbology UPCA = new Symbology(12, "UPCA");
    public static final Symbology EAN13 = new Symbology(13, "EAN13");
    public static final Symbology ISBN13 = new Symbology(14, "ISBN13");
    public static final Symbology I25 = new Symbology(25, "I25");
    public static final Symbology DATABAR = new Symbology(34, "DATABAR");
    public static final Symbology DATABAR_EXP = new Symbology(35, "DATABAR_EXP");
    public static final Symbology CODABAR = new Symbology(38, "CODABAR");
    public static final Symbology CODE39 = new Symbology(39, "CODE39");
    public static final Symbology PDF417 = new Symbology(57, "PDF417");
    public static final Symbology QRCODE = new Symbology(64, "QRCODE");
    public static final Symbology CODE93 = new Symbology(93, "CODE93");
    public static final Symbology CODE128 = new Symbology(128, "CODE128");
    public static final List<Symbology> ALL = new ArrayList<Symbology>();

    public Symbology(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public static Symbology getFormatById(int id) {
        for (Symbology format : ALL) {
            if (format.getId() != id) continue;
            return format;
        }
        return NONE;
    }

    static {
        ALL.add(PARTIAL);
        ALL.add(EAN8);
        ALL.add(UPCE);
        ALL.add(ISBN10);
        ALL.add(UPCA);
        ALL.add(EAN13);
        ALL.add(ISBN13);
        ALL.add(I25);
        ALL.add(DATABAR);
        ALL.add(DATABAR_EXP);
        ALL.add(CODABAR);
        ALL.add(CODE39);
        ALL.add(PDF417);
        ALL.add(QRCODE);
        ALL.add(CODE93);
        ALL.add(CODE128);
    }
}

