/*
 * Decompiled with CFR 0.152.
 */
package io.vin.android.scanner;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.View;
import io.vin.android.scanner.Result;
import io.vin.android.scanner.core.Camera1View;
import io.vin.android.scanner.engine.DecodeEngine;
import io.vin.android.scanner.engine.impl.ZbarDecodeEngine;
import io.vin.android.zbar.Symbology;
import java.util.List;

public class ScannerView2
extends Camera1View {
    private boolean canScan = true;
    private boolean canVibrate = false;
    private long lastScanTime = -1L;
    private Vibrator mVibrator;
    private SingleScanCallBack mSingleScanCallBack;
    private MultipleScanCallBack mMultipleScanCallBack;
    private DecodeEngine mDecodeEngine;
    private Camera.PreviewCallback mScanPreviewCallback;

    public ScannerView2(Context context) {
        super(context);
        this.initScanner();
    }

    public ScannerView2(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initScanner();
    }

    public ScannerView2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initScanner();
    }

    @Override
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        this.mScanPreviewCallback = callback;
        super.setPreviewCallback((data, camera) -> {
            try {
                this.handlePreviewFrame(data, camera);
                if (this.mScanPreviewCallback != null) {
                    this.mScanPreviewCallback.onPreviewFrame(data, camera);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void initScanner() {
        this.mDecodeEngine = new ZbarDecodeEngine(this.getContext(), (View)this);
        this.mVibrator = (Vibrator)this.getContext().getApplicationContext().getSystemService("vibrator");
        super.setPreviewCallback((data, camera) -> {
            try {
                this.handlePreviewFrame(data, camera);
                if (this.mScanPreviewCallback != null) {
                    this.mScanPreviewCallback.onPreviewFrame(data, camera);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void handlePreviewFrame(byte[] data, Camera camera) {
        if (!this.canScan || this.mSingleScanCallBack == null && this.mMultipleScanCallBack == null) {
            return;
        }
        List<Result> resultList = this.mDecodeEngine.decode(data, camera);
        if (!resultList.isEmpty()) {
            long nowTime;
            if (this.mSingleScanCallBack != null) {
                this.mSingleScanCallBack.singleScan(resultList.get(0));
            }
            if (this.mMultipleScanCallBack != null) {
                this.mMultipleScanCallBack.multipleScan(resultList);
            }
            if (this.canVibrate && (nowTime = System.currentTimeMillis()) - this.lastScanTime > 2000L) {
                this.mVibrator.vibrate(200L);
                this.lastScanTime = nowTime;
            }
        }
    }

    public void startScan() {
        this.canScan = true;
    }

    public void stopScan() {
        this.canScan = false;
    }

    public void enableVibrator(Boolean canVibrate) {
        this.canVibrate = canVibrate;
    }

    public void setDecoderEngine(DecodeEngine engine) {
        this.mDecodeEngine = engine;
    }

    public void enableCache(Boolean enable) {
        this.mDecodeEngine.enableCache(enable);
    }

    public void setSymbology(List<Symbology> symbologyList) {
        this.mDecodeEngine.setSymbology(symbologyList);
    }

    public void setDecodeRect(Rect decodeRect) {
        this.mDecodeEngine.setDecodeRect(decodeRect);
    }

    public void setDecodeRect(View view) {
        this.mDecodeEngine.setDecodeRect(view);
    }

    public void setSingleScanCallBack(SingleScanCallBack callBack) {
        this.mSingleScanCallBack = callBack;
    }

    public void removeSingleScanCallBack() {
        this.mSingleScanCallBack = null;
    }

    public void setMultipleScanCallBack(MultipleScanCallBack callBack) {
        this.mMultipleScanCallBack = callBack;
    }

    public void removeMultipleScanCallBack() {
        this.mMultipleScanCallBack = null;
    }

    public static interface MultipleScanCallBack {
        public void multipleScan(List<Result> var1);
    }

    public static interface SingleScanCallBack {
        public void singleScan(Result var1);
    }
}

