/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.impl.OrderListener;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.UserContextInternal;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.internal.handler.ScopedAuthentication;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OAuth2AuthHandlerImpl
extends HTTPAuthorizationHandler<OAuth2Auth>
implements OAuth2AuthHandler,
ScopedAuthentication<OAuth2AuthHandler>,
OrderListener {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthHandlerImpl.class);
    private final VertxContextPRNG prng;
    private final Origin callbackURL;
    private final MessageDigest sha256;
    private final List<String> scopes;
    private JsonObject extraParams;
    private String prompt;
    private int pkce = -1;
    private boolean bearerOnly = true;
    private int order = -1;
    private Route callback;
    private static final Set<String> OPENID_SCOPES = new HashSet<String>();

    public OAuth2AuthHandlerImpl(Vertx vertx, OAuth2Auth authProvider, String callbackURL) {
        this(vertx, authProvider, callbackURL, null);
    }

    public OAuth2AuthHandlerImpl(Vertx vertx, OAuth2Auth authProvider, String callbackURL, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER, realm);
        this.prng = VertxContextPRNG.current((Vertx)vertx);
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get instance of SHA-256 MessageDigest", e);
        }
        this.callbackURL = callbackURL != null ? Origin.parse(callbackURL) : null;
        this.scopes = Collections.emptyList();
    }

    private OAuth2AuthHandlerImpl(OAuth2AuthHandlerImpl base, List<String> scopes) {
        super((OAuth2Auth)base.authProvider, HTTPAuthorizationHandler.Type.BEARER, base.realm);
        this.prng = base.prng;
        this.callbackURL = base.callbackURL;
        this.prompt = base.prompt;
        this.pkce = base.pkce;
        this.bearerOnly = base.bearerOnly;
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot get instance of SHA-256 MessageDigest", e);
        }
        if (base.extraParams != null) {
            this.extraParams = base.extraParams.copy();
        }
        this.callback = base.callback;
        this.order = base.order;
        Objects.requireNonNull(scopes, "scopes cannot be null");
        this.scopes = scopes;
    }

    @Override
    public Future<User> authenticate(RoutingContext context) {
        return this.parseAuthorization(context, !this.bearerOnly).compose(token -> {
            if (token == null) {
                if (this.bearerOnly) {
                    return Future.failedFuture((String)"callback route is not configured.");
                }
                if (context.request().method() == HttpMethod.GET && context.normalizedPath().equals(this.callbackURL.resource())) {
                    LOG.warn((Object)"The callback route is shaded by the OAuth2AuthHandler, ensure the callback route is added BEFORE the OAuth2AuthHandler route!");
                    return Future.failedFuture((Throwable)new HttpException(500, "Infinite redirect loop [oauth2 callback]"));
                }
                if (context.request().method() != HttpMethod.GET) {
                    LOG.error((Object)"OAuth2 redirect attempt to non GET resource");
                    return Future.failedFuture((Throwable)new HttpException(405, (Throwable)new IllegalStateException("OAuth2 redirect attempt to non GET resource")));
                }
                String redirectUri = context.request().uri();
                try {
                    return Future.failedFuture((Throwable)new HttpException(302, this.authURI(context, redirectUri)));
                }
                catch (IllegalStateException e) {
                    return Future.failedFuture((Throwable)e);
                }
            }
            List scopes = this.getScopesOrSearchMetadata(this.scopes, context);
            TokenCredentials credentials = scopes.size() > 0 ? new TokenCredentials(token).setScopes(scopes) : new TokenCredentials(token);
            SecurityAudit audit = ((RoutingContextInternal)context).securityAudit();
            audit.credentials((Credentials)credentials);
            return ((OAuth2Auth)this.authProvider).authenticate((Credentials)credentials).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).recover(err -> Future.failedFuture((Throwable)new HttpException(401, (Throwable)err)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String authURI(RoutingContext context, String redirectURL) {
        List scopes;
        String state = null;
        String codeVerifier = null;
        String loginHint = null;
        Session session = context.session();
        if (session == null) {
            if (this.pkce > 0) {
                throw new IllegalStateException("OAuth2 PKCE requires a session to be present");
            }
        } else {
            loginHint = (String)session.get("login_hint");
            session.remove("login_hint");
            session.put("redirect_uri", redirectURL);
            state = this.prng.nextString(6);
            session.put("state", state);
            if (this.pkce > 0) {
                codeVerifier = this.prng.nextString(this.pkce);
                session.put("pkce", codeVerifier);
            }
        }
        OAuth2AuthorizationURL config = new OAuth2AuthorizationURL();
        if (this.extraParams != null) {
            for (Map.Entry entry : this.extraParams) {
                if (entry.getValue() == null) continue;
                config.putAdditionalParameter((String)entry.getKey(), entry.getValue().toString());
            }
        }
        config.setState(state != null ? state : redirectURL).setLoginHint(loginHint).setPrompt(this.prompt);
        if (this.callbackURL != null) {
            config.setRedirectUri(this.callbackURL.href());
        }
        if ((scopes = this.getScopesOrSearchMetadata(this.scopes, context)).size() > 0) {
            config.setScopes(scopes);
        }
        if (codeVerifier != null) {
            MessageDigest messageDigest = this.sha256;
            synchronized (messageDigest) {
                this.sha256.update(codeVerifier.getBytes(StandardCharsets.US_ASCII));
                config.setCodeChallenge(Utils.base64UrlEncode(this.sha256.digest())).setCodeChallengeMethod("S256");
            }
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(new OAuth2AuthorizationURL(config));
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler withScope(String scope) {
        Objects.requireNonNull(scope, "scope cannot be null");
        ArrayList<String> updatedScopes = new ArrayList<String>(this.scopes);
        updatedScopes.add(scope);
        return new OAuth2AuthHandlerImpl(this, updatedScopes);
    }

    @Override
    public OAuth2AuthHandler withScopes(List<String> scopes) {
        Objects.requireNonNull(scopes, "scopes cannot be null");
        return new OAuth2AuthHandlerImpl(this, scopes);
    }

    @Override
    public OAuth2AuthHandler prompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    @Override
    public OAuth2AuthHandler pkceVerifierLength(int length) {
        if (length >= 0 && (length < 43 || length > 128)) {
            throw new IllegalArgumentException("Length must be between 43 and 128");
        }
        this.pkce = length;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route) {
        if (this.callbackURL == null) {
            throw new IllegalStateException("OAuth2AuthHandler was created without a origin/callback URL");
        }
        String routePath = route.getPath();
        if (routePath == null) {
            throw new IllegalStateException("OAuth2AuthHandler callback route created without a path");
        }
        String callbackPath = this.callbackURL.resource();
        if (callbackPath != null && !"".equals(callbackPath) && !callbackPath.endsWith(routePath) && LOG.isWarnEnabled()) {
            LOG.warn((Object)"callback route doesn't match OAuth2AuthHandler origin configuration");
        }
        this.callback = route;
        if (this.order != -1) {
            this.mountCallback();
        }
        this.bearerOnly = false;
        return this;
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        List scopes = this.getScopesOrSearchMetadata(this.scopes, ctx);
        if (scopes.size() > 0) {
            String userScopes;
            User user = ctx.user();
            if (user == null) {
                ctx.fail(403, (Throwable)new VertxException("no user in the context", true));
                return;
            }
            if (user.principal().containsKey("scope") && (userScopes = user.principal().getString("scope")) != null) {
                boolean openId = userScopes.contains("openid");
                for (String scope : scopes) {
                    if (openId && OPENID_SCOPES.contains(scope)) continue;
                    int idx = userScopes.indexOf(scope);
                    if (idx != -1) {
                        if ((idx == 0 || userScopes.charAt(idx - 1) == ' ') && (idx + scope.length() == userScopes.length() || userScopes.charAt(idx + scope.length()) == ' ')) continue;
                        ctx.fail(403, (Throwable)new VertxException("principal scope != handler scopes", true));
                        return;
                    }
                    ctx.fail(403, (Throwable)new VertxException("principal scope != handler scopes", true));
                    return;
                }
            }
        }
        ctx.next();
    }

    @Override
    public boolean performsRedirect() {
        if (!this.bearerOnly) {
            return true;
        }
        return this.callbackURL != null;
    }

    @Override
    public void onOrder(int order) {
        if (this.order == -1) {
            this.order = order;
            if (this.callback != null) {
                this.mountCallback();
            }
        }
    }

    private void mountCallback() {
        this.callback.method(HttpMethod.GET).order(this.order - 1);
        this.callback.handler((Handler<RoutingContext>)((Handler)ctx -> {
            String resource;
            String error = ctx.request().getParam("error");
            if (error != null) {
                int errorCode;
                switch (error) {
                    case "invalid_token": {
                        errorCode = 401;
                        break;
                    }
                    case "insufficient_scope": {
                        errorCode = 403;
                        break;
                    }
                    default: {
                        errorCode = 400;
                    }
                }
                String errorDescription = ctx.request().getParam("error_description");
                if (errorDescription != null) {
                    ctx.fail(errorCode, (Throwable)new VertxException(error + ": " + errorDescription, true));
                } else {
                    ctx.fail(errorCode, (Throwable)new VertxException(error, true));
                }
                return;
            }
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400, (Throwable)new VertxException("Missing code parameter", true));
                return;
            }
            Oauth2Credentials credentials = new Oauth2Credentials().setFlow(OAuth2FlowType.AUTH_CODE).setCode(code);
            String state = ctx.request().getParam("state");
            if (state == null) {
                ctx.fail(400, (Throwable)new VertxException("Missing IdP state parameter to the callback endpoint", true));
                return;
            }
            Session session = ctx.session();
            if (session != null) {
                String ctxState = (String)session.remove("state");
                if (!state.equals(ctxState)) {
                    ctx.fail(401, (Throwable)new VertxException("Invalid oauth2 state", true));
                    return;
                }
                String codeVerifier = (String)session.remove("pkce");
                credentials.setCodeVerifier(codeVerifier);
                resource = (String)session.get("redirect_uri");
            } else {
                resource = state;
            }
            credentials.setRedirectUri(this.callbackURL.href());
            SecurityAudit audit = ((RoutingContextInternal)ctx).securityAudit();
            audit.credentials((Credentials)credentials);
            ((OAuth2Auth)this.authProvider).authenticate((Credentials)credentials).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).onFailure(ctx::fail).onSuccess(user -> {
                String location;
                ((UserContextInternal)ctx.userContext()).setUser((User)user);
                String string = location = resource != null ? resource : "/";
                if (session != null) {
                    session.regenerateId();
                } else if (location.length() != 0 && location.charAt(0) == '/') {
                    ctx.reroute(location);
                    return;
                }
                ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)location).setStatusCode(302).end("Redirecting to " + location + ".");
            });
        }));
    }

    static {
        OPENID_SCOPES.add("openid");
        OPENID_SCOPES.add("profile");
        OPENID_SCOPES.add("email");
        OPENID_SCOPES.add("phone");
        OPENID_SCOPES.add("offline");
    }
}

