/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.Objects;

public class BlockingHandlerDecorator
implements Handler<RoutingContext> {
    private final boolean ordered;
    private final Handler<RoutingContext> decoratedHandler;

    public BlockingHandlerDecorator(Handler<RoutingContext> decoratedHandler, boolean ordered) {
        Objects.requireNonNull(decoratedHandler);
        this.decoratedHandler = decoratedHandler;
        this.ordered = ordered;
    }

    public void handle(RoutingContext context) {
        Route currentRoute = context.currentRoute();
        context.vertx().executeBlocking(() -> {
            this.decoratedHandler.handle((Object)new RoutingContextDecorator(currentRoute, (RoutingContextInternal)context));
            return null;
        }, this.ordered).onComplete(res -> {
            if (res.failed()) {
                context.fail(res.cause());
            }
        });
    }
}

