/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.util.Base64;

public class BasicAuthHandlerImpl
extends HTTPAuthorizationHandler<AuthenticationProvider>
implements BasicAuthHandler {
    public BasicAuthHandlerImpl(AuthenticationProvider authProvider, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BASIC, realm);
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        this.parseAuthorization(context, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            String spass;
            String suser;
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            try {
                String decoded = new String(Base64.getDecoder().decode((String)parseAuthorization.result()));
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)new HttpException(400, (Throwable)e)));
                return;
            }
            this.authProvider.authenticate((Credentials)new UsernamePasswordCredentials(suser, spass), authn -> {
                if (authn.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)new HttpException(401, authn.cause())));
                } else {
                    handler.handle(authn);
                }
            });
        }));
    }
}

