/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.util.Base64;

public class BasicAuthHandlerImpl
extends HTTPAuthorizationHandler<AuthenticationProvider>
implements BasicAuthHandler {
    public BasicAuthHandlerImpl(AuthenticationProvider authProvider, String realm) {
        super(authProvider, realm, HTTPAuthorizationHandler.Type.BASIC);
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<Credentials>> handler) {
        this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            String spass;
            String suser;
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            try {
                String decoded = new String(Base64.getDecoder().decode((String)parseAuthorization.result()));
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e) {
                context.fail(e);
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)new UsernamePasswordCredentials(suser, spass)));
        }));
    }

    @Override
    public String authenticateHeader(RoutingContext context) {
        return "Basic realm=\"" + this.realm + "\"";
    }
}

