/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.webauthn.WebAuthn;
import io.vertx.ext.auth.webauthn.WebAuthnCredentials;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.WebAuthnHandler;

public class WebAuthnHandlerImpl
implements WebAuthnHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthnHandlerImpl.class);
    private final WebAuthn webAuthn;
    private Route register = null;
    private Route login = null;
    private Route response = null;

    public WebAuthnHandlerImpl(WebAuthn webAuthN) {
        this.webAuthn = webAuthN;
    }

    private static boolean isEmptyString(JsonObject json, String key) {
        try {
            if (json == null) {
                return true;
            }
            if (!json.containsKey(key)) {
                return true;
            }
            String s = json.getString(key);
            return s == null || "".equals(s);
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    private static boolean isEmptyObject(JsonObject json, String key) {
        try {
            if (json == null) {
                return true;
            }
            if (!json.containsKey(key)) {
                return true;
            }
            JsonObject s = json.getJsonObject(key);
            return s == null;
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    private static boolean matchesRoute(RoutingContext ctx, Route route) {
        if (route != null) {
            return ctx.request().method() == HttpMethod.POST && ctx.normalizedPath().equals(route.getPath());
        }
        return false;
    }

    public void handle(RoutingContext ctx) {
        if (this.response == null) {
            LOG.error((Object)"No callback mounted!");
            ctx.fail(500);
            return;
        }
        if (WebAuthnHandlerImpl.matchesRoute(ctx, this.response)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"The callback route is shaded by the WebAuthNAuthHandler, ensure the callback route is added BEFORE the WebAuthNAuthHandler route!");
            }
            ctx.fail(500);
            return;
        }
        if (WebAuthnHandlerImpl.matchesRoute(ctx, this.register)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"The register callback route is shaded by the WebAuthNAuthHandler, ensure the callback route is added BEFORE the WebAuthNAuthHandler route!");
            }
            ctx.fail(500);
            return;
        }
        if (WebAuthnHandlerImpl.matchesRoute(ctx, this.login)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"The login callback route is shaded by the WebAuthNAuthHandler, ensure the callback route is added BEFORE the WebAuthNAuthHandler route!");
            }
            ctx.fail(500);
            return;
        }
        if (ctx.user() == null) {
            ctx.fail(401);
        } else {
            ctx.next();
        }
    }

    @Override
    public WebAuthnHandler setupCredentialsCreateCallback(Route route) {
        this.register = route.method(HttpMethod.POST).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnRegister = ctx.getBodyAsJson();
                Session session = ctx.session();
                if (WebAuthnHandlerImpl.isEmptyString(webauthnRegister, "name") || WebAuthnHandlerImpl.isEmptyString(webauthnRegister, "displayName") || WebAuthnHandlerImpl.isEmptyString(webauthnRegister, "type")) {
                    ctx.fail(400);
                } else {
                    if (session == null) {
                        LOG.warn((Object)"No session or session handler is missing.");
                        ctx.fail(500);
                        return;
                    }
                    this.webAuthn.createCredentialsOptions(webauthnRegister, createCredentialsOptions -> {
                        if (createCredentialsOptions.failed()) {
                            ctx.fail(createCredentialsOptions.cause());
                            return;
                        }
                        JsonObject credentialsOptions = (JsonObject)createCredentialsOptions.result();
                        ctx.session().put("challenge", credentialsOptions.getString("challenge")).put("username", webauthnRegister.getString("name"));
                        ctx.json(credentialsOptions);
                    });
                }
            }
            catch (IllegalArgumentException e) {
                ctx.fail(400);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Unexpected exception", (Throwable)e);
                ctx.fail(e);
            }
        }));
        return this;
    }

    @Override
    public WebAuthnHandler setupCredentialsGetCallback(Route route) {
        this.login = route.method(HttpMethod.POST).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnLogin = ctx.getBodyAsJson();
                Session session = ctx.session();
                if (WebAuthnHandlerImpl.isEmptyString(webauthnLogin, "name")) {
                    LOG.debug((Object)"Request missing username field");
                    ctx.fail(400);
                    return;
                }
                if (session == null) {
                    LOG.warn((Object)"No session or session handler is missing.");
                    ctx.fail(500);
                    return;
                }
                String username = webauthnLogin.getString("name");
                this.webAuthn.getCredentialsOptions(username, generateServerGetAssertion -> {
                    if (generateServerGetAssertion.failed()) {
                        LOG.error((Object)"Unexpected exception", generateServerGetAssertion.cause());
                        ctx.fail(generateServerGetAssertion.cause());
                        return;
                    }
                    JsonObject getAssertion = (JsonObject)generateServerGetAssertion.result();
                    session.put("challenge", getAssertion.getString("challenge")).put("username", username);
                    ctx.json(getAssertion);
                });
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Unexpected exception", (Throwable)e);
                ctx.fail(400);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Unexpected exception", (Throwable)e);
                ctx.fail(e);
            }
        }));
        return this;
    }

    @Override
    public WebAuthnHandler setupCallback(Route route) {
        this.response = route.method(HttpMethod.POST).handler((Handler<RoutingContext>)((Handler)ctx -> {
            try {
                JsonObject webauthnResp = ctx.getBodyAsJson();
                if (WebAuthnHandlerImpl.isEmptyString(webauthnResp, "id") || WebAuthnHandlerImpl.isEmptyString(webauthnResp, "rawId") || WebAuthnHandlerImpl.isEmptyObject(webauthnResp, "response") || WebAuthnHandlerImpl.isEmptyString(webauthnResp, "type") || !"public-key".equals(webauthnResp.getString("type"))) {
                    LOG.debug((Object)"Response missing one or more of id/rawId/response/type fields, or type is not public-key");
                    ctx.fail(400);
                    return;
                }
                Session session = ctx.session();
                if (ctx.session() == null) {
                    LOG.error((Object)"No session or session handler is missing.");
                    ctx.fail(500);
                    return;
                }
                this.webAuthn.authenticate(new WebAuthnCredentials().setChallenge((String)session.get("challenge")).setUsername((String)session.get("username")).setWebauthn(webauthnResp), authenticate -> {
                    session.remove("challenge");
                    if (authenticate.succeeded()) {
                        User user = (User)authenticate.result();
                        ctx.setUser(user);
                        session.regenerateId();
                        ctx.response().end();
                    } else {
                        LOG.error((Object)"Unexpected exception", authenticate.cause());
                        ctx.fail(authenticate.cause());
                    }
                });
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Unexpected exception", (Throwable)e);
                ctx.fail(400);
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Unexpected exception", (Throwable)e);
                ctx.fail(e);
            }
        }));
        return this;
    }
}

