/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigestAuthHandlerImpl
extends HTTPAuthorizationHandler
implements DigestAuthHandler {
    private static final String DEFAULT_NONCE_MAP_NAME = "htdigest.nonces";
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final Pattern SPLITTER = Pattern.compile(",(?=(?:[^\"]|\"[^\"]*\")*$)");
    private static final MessageDigest MD5;
    private final VertxContextPRNG random;
    private final LocalMap<String, Nonce> nonces;
    private final long nonceExpireTimeout;
    private long lastExpireRun;
    private static final char[] hexArray;

    public DigestAuthHandlerImpl(Vertx vertx, HtdigestAuth authProvider, long nonceExpireTimeout) {
        super((AuthenticationProvider)authProvider, authProvider.realm(), HTTPAuthorizationHandler.Type.DIGEST);
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.nonces = vertx.sharedData().getLocalMap(DEFAULT_NONCE_MAP_NAME);
        this.nonceExpireTimeout = nonceExpireTimeout;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        long now = System.currentTimeMillis();
        if (now - this.lastExpireRun > this.nonceExpireTimeout / 2L) {
            HashSet toRemove = new HashSet();
            this.nonces.forEach((key, n) -> {
                if (n != null && ((Nonce)n).createdAt + this.nonceExpireTimeout < now) {
                    toRemove.add(key);
                }
            });
            for (String n2 : toRemove) {
                this.nonces.remove((Object)n2);
            }
            this.lastExpireRun = now;
        }
        this.parseAuthorization(context, false, (Handler<AsyncResult<String>>)((Handler)parseAuthorization -> {
            String opaque;
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            JsonObject authInfo = new JsonObject();
            try {
                String[] tokens = SPLITTER.split((CharSequence)parseAuthorization.result());
                int len = tokens.length;
                for (int i = 0; i < len; ++i) {
                    Matcher m = PARSER.matcher(tokens[i]);
                    if (!m.find()) continue;
                    authInfo.put(m.group(1), (Object)m.group(2));
                }
                String nonce = authInfo.getString("nonce");
                if (!this.nonces.containsKey((Object)nonce)) {
                    handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
                    return;
                }
                if (authInfo.containsKey("qop")) {
                    Nonce n;
                    int nc = Integer.parseInt(authInfo.getString("nc"), 16);
                    if (nc <= (n = (Nonce)this.nonces.get((Object)nonce)).count) {
                        handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
                        return;
                    }
                    this.nonces.put((Object)nonce, (Object)new Nonce(n.createdAt, nc));
                }
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
            Session session = context.session();
            if (session != null && (opaque = (String)session.data().get("opaque")) != null && !opaque.equals(authInfo.getString("opaque"))) {
                handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
                return;
            }
            authInfo.put("method", (Object)context.request().method().name());
            handler.handle((Object)Future.succeededFuture((Object)authInfo));
        }));
    }

    @Override
    public String authenticateHeader(RoutingContext context) {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        String nonce = DigestAuthHandlerImpl.md5(bytes);
        this.nonces.put((Object)nonce, (Object)new Nonce(0));
        String opaque = null;
        Session session = context.session();
        if (session != null) {
            opaque = (String)session.data().get("opaque");
        }
        if (opaque == null) {
            this.random.nextBytes(bytes);
            opaque = DigestAuthHandlerImpl.md5(bytes);
        }
        return "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\", opaque=\"" + opaque + "\"";
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static synchronized String md5(byte[] payload) {
        MD5.reset();
        return DigestAuthHandlerImpl.bytesToHex(MD5.digest(payload));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        hexArray = "0123456789abcdef".toCharArray();
    }

    private static class Nonce
    implements Shareable {
        private final long createdAt;
        private final int count;

        Nonce(int count) {
            this(System.currentTimeMillis(), count);
        }

        Nonce(long createdAt, int count) {
            this.createdAt = createdAt;
            this.count = count;
        }
    }
}

