/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CSRFHandlerImpl
implements CSRFHandler {
    private static final Logger log = LoggerFactory.getLogger(CSRFHandlerImpl.class);
    private static final Base64.Encoder BASE64 = Base64.getMimeEncoder();
    private final VertxContextPRNG random;
    private final Mac mac;
    private boolean nagHttps;
    private String cookieName = "XSRF-TOKEN";
    private String cookiePath = "/";
    private String headerName = "X-XSRF-TOKEN";
    private String responseBody = DEFAULT_RESPONSE_BODY;
    private long timeout = 1800000L;

    public CSRFHandlerImpl(Vertx vertx, String secret) {
        try {
            this.random = VertxContextPRNG.current((Vertx)vertx);
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(new SecretKeySpec(secret.getBytes(), "HmacSHA256"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CSRFHandler setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    @Override
    public CSRFHandler setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    @Override
    public CSRFHandler setHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    @Override
    public CSRFHandler setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public CSRFHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public CSRFHandler setResponseBody(String responseBody) {
        this.responseBody = responseBody;
        return this;
    }

    private String generateAndStoreToken(RoutingContext ctx) {
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        String saltPlusToken = BASE64.encodeToString(salt) + "." + System.currentTimeMillis();
        String signature = BASE64.encodeToString(this.mac.doFinal(saltPlusToken.getBytes()));
        String token = saltPlusToken + "." + signature;
        ctx.addCookie(Cookie.cookie((String)this.cookieName, (String)token).setPath(this.cookiePath));
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateRequest(RoutingContext ctx) {
        Cookie cookie = ctx.getCookie(this.cookieName);
        if (cookie == null) {
            return false;
        }
        String challenge = this.getTokenFromSession(ctx);
        boolean invalidateSessionToken = false;
        if (challenge == null) {
            challenge = ctx.request().getHeader(this.headerName);
            if (challenge == null) {
                challenge = ctx.request().getFormAttribute(this.headerName);
            }
        } else {
            invalidateSessionToken = true;
        }
        if (challenge == null || !challenge.equals(cookie.getValue())) {
            return false;
        }
        String[] tokens = challenge.split("\\.");
        if (tokens.length != 3) {
            return false;
        }
        byte[] saltPlusToken = (tokens[0] + "." + tokens[1]).getBytes();
        Mac mac = this.mac;
        synchronized (mac) {
            saltPlusToken = this.mac.doFinal(saltPlusToken);
        }
        String signature = BASE64.encodeToString(saltPlusToken);
        if (!signature.equals(tokens[2])) {
            return false;
        }
        try {
            if (System.currentTimeMillis() <= Long.parseLong(tokens[1]) + this.timeout) {
                if (invalidateSessionToken) {
                    ctx.session().remove(this.headerName);
                }
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected void forbidden(RoutingContext ctx) {
        int statusCode = 403;
        if (this.responseBody != null) {
            ctx.response().setStatusCode(403).end(this.responseBody);
        } else {
            ctx.fail(new HttpStatusException(403, "Invalid or missing csrf token"));
        }
    }

    private String getTokenFromSession(RoutingContext ctx) {
        int idx;
        Session session = ctx.session();
        if (session == null) {
            return null;
        }
        String sessionToken = (String)session.get(this.headerName);
        if (sessionToken != null && (idx = sessionToken.indexOf(47)) != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
            return sessionToken.substring(idx + 1);
        }
        return null;
    }

    public void handle(RoutingContext ctx) {
        String uri;
        if (this.nagHttps && (uri = ctx.request().absoluteURI()) != null && !uri.startsWith("https:")) {
            log.warn((Object)("Using session cookies without https could make you susceptible to session hijacking: " + uri));
        }
        HttpMethod method = ctx.request().method();
        Session session = ctx.session();
        switch (method) {
            case GET: {
                String token;
                if (session == null) {
                    token = this.generateAndStoreToken(ctx);
                } else {
                    String sessionToken = this.getTokenFromSession(ctx);
                    if (sessionToken == null) {
                        token = this.generateAndStoreToken(ctx);
                        session.put(this.headerName, session.id() + "/" + token);
                    } else {
                        token = sessionToken;
                    }
                }
                ctx.put(this.headerName, token);
                ctx.next();
                break;
            }
            case POST: 
            case PUT: 
            case DELETE: 
            case PATCH: {
                if (this.validateRequest(ctx)) {
                    ctx.next();
                    break;
                }
                this.forbidden(ctx);
                break;
            }
            default: {
                ctx.next();
            }
        }
    }
}

