/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.Http2PushMapping;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.impl.LRUCache;
import io.vertx.ext.web.impl.Utils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticHandlerImpl
implements StaticHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHandlerImpl.class);
    private Map<String, CacheEntry> propsCache;
    private String webRoot = "webroot";
    private long maxAgeSeconds = 86400L;
    private boolean directoryListing = false;
    private String directoryTemplateResource = "META-INF/vertx/web/vertx-web-directory.html";
    private String directoryTemplate;
    private boolean includeHidden = true;
    private boolean filesReadOnly = true;
    private boolean cachingEnabled = DEFAULT_CACHING_ENABLED;
    private long cacheEntryTimeout = 30000L;
    private String indexPage = "/index.html";
    private List<Http2PushMapping> http2PushMappings;
    private int maxCacheSize = 10000;
    private boolean rangeSupport = true;
    private boolean allowRootFileSystemAccess = false;
    private boolean sendVaryHeader = true;
    private String defaultContentEncoding = Charset.defaultCharset().name();
    private static int NUM_SERVES_TUNING_FS_ACCESS = 1000;
    private boolean alwaysAsyncFS = false;
    private long maxAvgServeTimeNanoSeconds = 1000000L;
    private boolean tuning = true;
    private long totalTime;
    private long numServesBlocking;
    private boolean useAsyncFS;
    private long nextAvgCheck = NUM_SERVES_TUNING_FS_ACCESS;
    private Set<String> compressedMediaTypes = Collections.emptySet();
    private Set<String> compressedFileSuffixes = Collections.emptySet();
    private final ClassLoader classLoader;
    private static final Pattern RANGE = Pattern.compile("^bytes=(\\d+)-(\\d*)$");

    public StaticHandlerImpl(String root, ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (root != null) {
            this.setRoot(root);
        }
    }

    private String directoryTemplate(Vertx vertx) {
        if (this.directoryTemplate == null) {
            this.directoryTemplate = Utils.readFileToString(vertx, this.directoryTemplateResource);
        }
        return this.directoryTemplate;
    }

    private void writeCacheHeaders(HttpServerRequest request, FileProps props) {
        MultiMap headers = request.response().headers();
        if (this.cachingEnabled) {
            Utils.addToMapIfAbsent(headers, HttpHeaders.CACHE_CONTROL, "public, max-age=" + this.maxAgeSeconds);
            Utils.addToMapIfAbsent(headers, HttpHeaders.LAST_MODIFIED, Utils.formatRFC1123DateTime(props.lastModifiedTime()));
            if (this.sendVaryHeader && request.headers().contains(HttpHeaders.ACCEPT_ENCODING)) {
                Utils.addToMapIfAbsent(headers, "Vary", "accept-encoding");
            }
        }
        headers.set("date", Utils.formatRFC1123DateTime(System.currentTimeMillis()));
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Not GET or HEAD so ignoring request");
            }
            context.next();
        } else {
            String path = HttpUtils.removeDots((CharSequence)URIDecoder.decodeURIComponent((String)context.normalisedPath(), (boolean)false));
            if (path == null) {
                log.warn((Object)("Invalid path: " + context.request().path()));
                context.next();
                return;
            }
            if (!this.directoryListing && "/".equals(path)) {
                path = this.indexPage;
            }
            this.sendStatic(context, path);
        }
    }

    private void sendStatic(RoutingContext context, String path) {
        CacheEntry entry;
        int idx;
        String name;
        String file = null;
        if (!this.includeHidden && (name = (file = this.getFile(path, context)).substring((idx = file.lastIndexOf(47)) + 1)).length() > 0 && name.charAt(0) == '.') {
            context.next();
            return;
        }
        CacheEntry cacheEntry = entry = this.cachingEnabled ? this.propsCache().get(path) : null;
        if (entry != null) {
            long lastModified = Utils.secondsFactor(entry.props.lastModifiedTime());
            if ((this.filesReadOnly || !entry.isOutOfDate()) && Utils.fresh(context, lastModified)) {
                context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                return;
            }
        }
        boolean dirty = this.cachingEnabled && entry != null;
        String sfile = file == null ? this.getFile(path, context) : file;
        this.isFileExisting(context, sfile, (Handler<AsyncResult<Boolean>>)((Handler)exists -> {
            if (exists.failed()) {
                context.fail(exists.cause());
                return;
            }
            if (!((Boolean)exists.result()).booleanValue()) {
                if (dirty) {
                    this.removeCache(path);
                }
                context.next();
                return;
            }
            this.getFileProps(context, sfile, (Handler<AsyncResult<FileProps>>)((Handler)res -> {
                if (res.succeeded()) {
                    FileProps fprops = (FileProps)res.result();
                    if (fprops == null) {
                        if (dirty) {
                            this.removeCache(path);
                        }
                        context.next();
                    } else if (fprops.isDirectory()) {
                        if (dirty) {
                            this.removeCache(path);
                        }
                        this.sendDirectory(context, path, sfile);
                    } else {
                        if (this.cachingEnabled) {
                            CacheEntry now = new CacheEntry(fprops, this.cacheEntryTimeout);
                            this.propsCache().put(path, now);
                            if (Utils.fresh(context, Utils.secondsFactor(fprops.lastModifiedTime()))) {
                                context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                                return;
                            }
                        }
                        this.sendFile(context, sfile, fprops);
                    }
                } else {
                    context.fail(res.cause());
                }
            }));
        }));
    }

    private void sendDirectory(RoutingContext context, String path, String file) {
        if (!path.endsWith("/")) {
            context.response().putHeader(HttpHeaders.LOCATION, (CharSequence)(path + "/")).setStatusCode(301).end();
            return;
        }
        if (this.directoryListing) {
            this.sendDirectoryListing(file, context);
        } else if (this.indexPage != null) {
            String indexPath = this.indexPage.startsWith("/") ? path + this.indexPage.substring(1) : path + this.indexPage;
            this.sendStatic(context, indexPath);
        } else {
            context.fail(HttpResponseStatus.FORBIDDEN.code());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T wrapInTCCLSwitch(Callable<T> callable) {
        try {
            if (this.classLoader == null) {
                return callable.call();
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                T t = callable.call();
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void isFileExisting(RoutingContext context, String file, Handler<AsyncResult<Boolean>> resultHandler) {
        FileSystem fs = context.vertx().fileSystem();
        this.wrapInTCCLSwitch(() -> fs.exists(file, resultHandler));
    }

    private synchronized void getFileProps(RoutingContext context, String file, Handler<AsyncResult<FileProps>> resultHandler) {
        FileSystem fs = context.vertx().fileSystem();
        if (this.alwaysAsyncFS || this.useAsyncFS) {
            this.wrapInTCCLSwitch(() -> fs.props(file, resultHandler));
        } else {
            long start = 0L;
            if (this.tuning) {
                start = System.nanoTime();
            }
            try {
                FileProps props = this.wrapInTCCLSwitch(() -> fs.propsBlocking(file));
                if (this.tuning) {
                    long end = System.nanoTime();
                    long dur = end - start;
                    this.totalTime += dur;
                    ++this.numServesBlocking;
                    if (this.numServesBlocking == Long.MAX_VALUE) {
                        this.resetTuning();
                    } else if (this.numServesBlocking == this.nextAvgCheck) {
                        double avg = (double)this.totalTime / (double)this.numServesBlocking;
                        if (avg > (double)this.maxAvgServeTimeNanoSeconds) {
                            this.useAsyncFS = true;
                            log.info((Object)("Switching to async file system access in static file server as fs access is slow! (Average access time of " + avg + " ns)"));
                            this.tuning = false;
                        }
                        this.nextAvgCheck += (long)NUM_SERVES_TUNING_FS_ACCESS;
                    }
                }
                resultHandler.handle((Object)Future.succeededFuture((Object)props));
            }
            catch (RuntimeException e) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)e.getCause()));
            }
        }
    }

    private void resetTuning() {
        this.nextAvgCheck = NUM_SERVES_TUNING_FS_ACCESS;
        this.totalTime = 0L;
        this.numServesBlocking = 0L;
    }

    private void sendFile(RoutingContext context, String file, FileProps fileProps) {
        HttpServerRequest request = context.request();
        Long offset = null;
        Long end = null;
        MultiMap headers = null;
        if (request.response().closed()) {
            return;
        }
        if (this.rangeSupport) {
            Matcher m;
            String range = request.getHeader("Range");
            end = fileProps.size() - 1L;
            if (range != null && (m = RANGE.matcher(range)).matches()) {
                try {
                    String part = m.group(1);
                    offset = Long.parseLong(part);
                    if (offset < 0L || offset >= fileProps.size()) {
                        throw new IndexOutOfBoundsException();
                    }
                    part = m.group(2);
                    if (part != null && part.length() > 0 && (end = Long.valueOf(Math.min(end, Long.parseLong(part)))) < offset) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    context.response().putHeader(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes */" + fileProps.size()));
                    context.fail(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code());
                    return;
                }
            }
            headers = request.response().headers();
            headers.set(HttpHeaders.ACCEPT_RANGES, (CharSequence)"bytes");
            headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(end + 1L - (offset == null ? 0L : offset)));
        }
        this.writeCacheHeaders(request, fileProps);
        if (request.method() == HttpMethod.HEAD) {
            request.response().end();
        } else if (this.rangeSupport && offset != null) {
            headers.set(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes " + offset + "-" + end + "/" + fileProps.size()));
            request.response().setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code());
            long finalOffset = offset;
            long finalLength = end + 1L - offset;
            this.wrapInTCCLSwitch(() -> {
                String contentType = MimeMapping.getMimeTypeForFilename((String)file);
                if (contentType != null) {
                    if (contentType.startsWith("text")) {
                        request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                    } else {
                        request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                    }
                }
                return request.response().sendFile(file, finalOffset, finalLength, res2 -> {
                    if (res2.failed()) {
                        context.fail(res2.cause());
                    }
                });
            });
        } else {
            this.wrapInTCCLSwitch(() -> {
                String extension = this.getFileExtension(file);
                String contentType = MimeMapping.getMimeTypeForExtension((String)extension);
                if (this.compressedMediaTypes.contains(contentType) || this.compressedFileSuffixes.contains(extension)) {
                    request.response().putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY);
                }
                if (contentType != null) {
                    if (contentType.startsWith("text")) {
                        request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                    } else {
                        request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                    }
                }
                if (request.version() == HttpVersion.HTTP_2 && this.http2PushMappings != null) {
                    for (Http2PushMapping dependency : this.http2PushMappings) {
                        if (dependency.isNoPush()) continue;
                        String dep = this.webRoot + "/" + dependency.getFilePath();
                        HttpServerResponse response = request.response();
                        this.getFileProps(context, dep, (Handler<AsyncResult<FileProps>>)((Handler)filePropsAsyncResult -> {
                            if (filePropsAsyncResult.succeeded()) {
                                this.writeCacheHeaders(request, (FileProps)filePropsAsyncResult.result());
                                response.push(HttpMethod.GET, "/" + dependency.getFilePath(), pushAsyncResult -> {
                                    if (pushAsyncResult.succeeded()) {
                                        HttpServerResponse res = (HttpServerResponse)pushAsyncResult.result();
                                        String depContentType = MimeMapping.getMimeTypeForExtension((String)file);
                                        if (depContentType != null) {
                                            if (depContentType.startsWith("text")) {
                                                res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                                            } else {
                                                res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                                            }
                                        }
                                        res.sendFile(this.webRoot + "/" + dependency.getFilePath());
                                    }
                                });
                            }
                        }));
                    }
                } else if (this.http2PushMappings != null) {
                    HttpServerResponse response = request.response();
                    ArrayList links = new ArrayList();
                    for (Http2PushMapping dependency : this.http2PushMappings) {
                        String dep = this.webRoot + "/" + dependency.getFilePath();
                        this.getFileProps(context, dep, (Handler<AsyncResult<FileProps>>)((Handler)filePropsAsyncResult -> {
                            if (filePropsAsyncResult.succeeded()) {
                                this.writeCacheHeaders(request, (FileProps)filePropsAsyncResult.result());
                                links.add("<" + dependency.getFilePath() + ">; rel=preload; as=" + dependency.getExtensionTarget() + (dependency.isNoPush() ? "; nopush" : ""));
                            }
                        }));
                    }
                    response.putHeader("Link", links);
                }
                return request.response().sendFile(file, res2 -> {
                    if (res2.failed()) {
                        context.fail(res2.cause());
                    }
                });
            });
        }
    }

    @Override
    public StaticHandler setAllowRootFileSystemAccess(boolean allowRootFileSystemAccess) {
        this.allowRootFileSystemAccess = allowRootFileSystemAccess;
        return this;
    }

    @Override
    public StaticHandler setWebRoot(String webRoot) {
        this.setRoot(webRoot);
        return this;
    }

    @Override
    public StaticHandler setFilesReadOnly(boolean readOnly) {
        this.filesReadOnly = readOnly;
        return this;
    }

    @Override
    public StaticHandler setMaxAgeSeconds(long maxAgeSeconds) {
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.maxAgeSeconds = maxAgeSeconds;
        return this;
    }

    @Override
    public StaticHandler setMaxCacheSize(int maxCacheSize) {
        if (maxCacheSize < 1) {
            throw new IllegalArgumentException("maxCacheSize must be >= 1");
        }
        this.maxCacheSize = maxCacheSize;
        return this;
    }

    @Override
    public StaticHandler setCachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
        return this;
    }

    @Override
    public StaticHandler setDirectoryListing(boolean directoryListing) {
        this.directoryListing = directoryListing;
        return this;
    }

    @Override
    public StaticHandler setDirectoryTemplate(String directoryTemplate) {
        this.directoryTemplateResource = directoryTemplate;
        this.directoryTemplate = null;
        return this;
    }

    @Override
    public StaticHandler setEnableRangeSupport(boolean enableRangeSupport) {
        this.rangeSupport = enableRangeSupport;
        return this;
    }

    @Override
    public StaticHandler setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        return this;
    }

    @Override
    public StaticHandler setCacheEntryTimeout(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout must be >= 1");
        }
        this.cacheEntryTimeout = timeout;
        return this;
    }

    @Override
    public StaticHandler setIndexPage(String indexPage) {
        Objects.requireNonNull(indexPage);
        if (!indexPage.startsWith("/")) {
            indexPage = "/" + indexPage;
        }
        this.indexPage = indexPage;
        return this;
    }

    @Override
    public StaticHandler setAlwaysAsyncFS(boolean alwaysAsyncFS) {
        this.alwaysAsyncFS = alwaysAsyncFS;
        return this;
    }

    @Override
    public StaticHandler setHttp2PushMapping(List<Http2PushMapping> http2PushMap) {
        if (http2PushMap != null) {
            this.http2PushMappings = new ArrayList<Http2PushMapping>(http2PushMap);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForMediaTypes(Set<String> mediaTypes) {
        if (mediaTypes != null) {
            this.compressedMediaTypes = new HashSet<String>(mediaTypes);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForSuffixes(Set<String> fileSuffixes) {
        if (fileSuffixes != null) {
            this.compressedFileSuffixes = new HashSet<String>(fileSuffixes);
        }
        return this;
    }

    @Override
    public synchronized StaticHandler setEnableFSTuning(boolean enableFSTuning) {
        this.tuning = enableFSTuning;
        if (!this.tuning) {
            this.resetTuning();
        }
        return this;
    }

    @Override
    public StaticHandler setMaxAvgServeTimeNs(long maxAvgServeTimeNanoSeconds) {
        this.maxAvgServeTimeNanoSeconds = maxAvgServeTimeNanoSeconds;
        return this;
    }

    @Override
    public StaticHandler setSendVaryHeader(boolean sendVaryHeader) {
        this.sendVaryHeader = sendVaryHeader;
        return this;
    }

    @Override
    public StaticHandler setDefaultContentEncoding(String contentEncoding) {
        this.defaultContentEncoding = contentEncoding;
        return this;
    }

    private Map<String, CacheEntry> propsCache() {
        if (this.propsCache == null) {
            this.propsCache = new LRUCache<String, CacheEntry>(this.maxCacheSize);
        }
        return this.propsCache;
    }

    private void removeCache(String path) {
        if (this.propsCache != null) {
            this.propsCache.remove(path);
        }
    }

    private String getFile(String path, RoutingContext context) {
        String file = this.webRoot + Utils.pathOffset(path, context);
        if (log.isTraceEnabled()) {
            log.trace((Object)("File to serve is " + file));
        }
        return file;
    }

    private void setRoot(String webRoot) {
        Objects.requireNonNull(webRoot);
        if (!this.allowRootFileSystemAccess) {
            for (File root : File.listRoots()) {
                if (!webRoot.startsWith(root.getAbsolutePath())) continue;
                throw new IllegalArgumentException("root cannot start with '" + root.getAbsolutePath() + "'");
            }
        }
        this.webRoot = webRoot;
    }

    private void sendDirectoryListing(String dir, RoutingContext context) {
        FileSystem fileSystem = context.vertx().fileSystem();
        HttpServerRequest request = context.request();
        fileSystem.readDir(dir, asyncResult -> {
            if (asyncResult.failed()) {
                context.fail(asyncResult.cause());
            } else {
                String accept = request.headers().get("accept");
                if (accept == null) {
                    accept = "text/plain";
                }
                if (accept.contains("html")) {
                    String normalizedDir = context.normalisedPath();
                    if (!normalizedDir.endsWith("/")) {
                        normalizedDir = normalizedDir + "/";
                    }
                    StringBuilder files = new StringBuilder("<ul id=\"files\">");
                    List list = (List)asyncResult.result();
                    Collections.sort(list);
                    for (String s : list) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        files.append("<li><a href=\"");
                        files.append(normalizedDir);
                        files.append(file);
                        files.append("\" title=\"");
                        files.append(file);
                        files.append("\">");
                        files.append(file);
                        files.append("</a></li>");
                    }
                    files.append("</ul>");
                    int slashPos = 0;
                    for (int i = normalizedDir.length() - 2; i > 0; --i) {
                        if (normalizedDir.charAt(i) != '/') continue;
                        slashPos = i;
                        break;
                    }
                    String parent = "<a href=\"" + normalizedDir.substring(0, slashPos + 1) + "\">..</a>";
                    request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
                    request.response().end(this.directoryTemplate(context.vertx()).replace("{directory}", normalizedDir).replace("{parent}", parent).replace("{files}", files.toString()));
                } else if (accept.contains("json")) {
                    JsonArray json = new JsonArray();
                    for (String s : (List)asyncResult.result()) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        json.add(file);
                    }
                    request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
                    request.response().end(json.encode());
                } else {
                    StringBuilder buffer = new StringBuilder();
                    for (String s : (List)asyncResult.result()) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        buffer.append(file);
                        buffer.append('\n');
                    }
                    request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
                    request.response().end(buffer.toString());
                }
            }
        });
    }

    private String getFileExtension(String file) {
        int li = file.lastIndexOf(46);
        if (li != -1 && li != file.length() - 1) {
            return file.substring(li + 1);
        }
        return null;
    }

    private static final class CacheEntry {
        final long createDate = System.currentTimeMillis();
        final FileProps props;
        final long cacheEntryTimeout;

        private CacheEntry(FileProps props, long cacheEntryTimeout) {
            this.props = props;
            this.cacheEntryTimeout = cacheEntryTimeout;
        }

        boolean isOutOfDate() {
            return System.currentTimeMillis() - this.createDate > this.cacheEntryTimeout;
        }
    }
}

